/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.channels;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.apache.commons.io.channels.FileChannelProxy;

class NonBlockingFileChannelProxy
extends FileChannelProxy {
    boolean toggleRead0;

    NonBlockingFileChannelProxy(FileChannel fileChannel) {
        super(fileChannel);
    }

    private boolean flipState() {
        this.toggleRead0 = !this.toggleRead0;
        return this.toggleRead0;
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        return this.flipState() ? 0 : super.read(dst);
    }

    @Override
    public int read(ByteBuffer dst, long position) throws IOException {
        this.flipState();
        return this.flipState() ? 0 : super.read(dst, position);
    }

    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        return this.flipState() ? 0L : super.read(dsts, offset, length);
    }
}

