/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.bag;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.collections4.Bag;
import org.apache.commons.collections4.SortedBag;
import org.apache.commons.collections4.bag.CollectionSortedBag;
import org.apache.commons.collections4.bag.TreeBag;
import org.apache.commons.collections4.collection.AbstractCollectionTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CollectionSortedBagTest<T>
extends AbstractCollectionTest<T> {
    @Override
    public String getCompatibilityVersion() {
        return "4";
    }

    @Override
    public T[] getFullNonNullElements() {
        Object[] elements = new Object[30];
        for (int i = 0; i < 30; ++i) {
            elements[i] = i + i + 1;
        }
        return elements;
    }

    @Override
    public T[] getOtherNonNullElements() {
        Object[] elements = new Object[30];
        for (int i = 0; i < 30; ++i) {
            elements[i] = i + i + 2;
        }
        return elements;
    }

    @Override
    public boolean isNullSupported() {
        return false;
    }

    @Override
    public Collection<T> makeConfirmedCollection() {
        return new ArrayList();
    }

    @Override
    public Collection<T> makeConfirmedFullCollection() {
        Collection<T> set = this.makeConfirmedCollection();
        set.addAll(Arrays.asList(this.getFullElements()));
        return set;
    }

    @Override
    public Bag<T> makeObject() {
        return CollectionSortedBag.collectionSortedBag((SortedBag)new TreeBag());
    }

    @Test
    public void testEmptyBagCompatibility() throws IOException, ClassNotFoundException {
        Bag<T> bag = this.makeObject();
        if (bag instanceof Serializable && !this.skipSerializedCanonicalTests() && this.isTestSerialization()) {
            Bag bag2 = (Bag)this.readExternalFormFromDisk(this.getCanonicalEmptyCollectionName(bag));
            Assertions.assertEquals((int)0, (int)bag2.size(), (String)"Bag is empty");
            Assertions.assertEquals(bag, (Object)bag2);
        }
    }

    @Test
    public void testFullBagCompatibility() throws IOException, ClassNotFoundException {
        SortedBag bag = (SortedBag)this.makeFullCollection();
        if (bag instanceof Serializable && !this.skipSerializedCanonicalTests() && this.isTestSerialization()) {
            SortedBag bag2 = (SortedBag)this.readExternalFormFromDisk(this.getCanonicalFullCollectionName(bag));
            Assertions.assertEquals((int)bag.size(), (int)bag2.size(), (String)"Bag is the right size");
            Assertions.assertEquals((Object)bag, (Object)bag2);
        }
    }
}

