/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.brooklyn.entity.stock;

import org.apache.brooklyn.core.entity.AbstractApplication;
import org.apache.brooklyn.util.text.Strings;

public class BasicApplicationImpl extends AbstractApplication implements BasicApplication {

    @Override
    public void init() {
        // Set the default name *before* calling super.init(), and only do so if we don't have an 
        // explicit default. This is a belt-and-braces fix: before we overwrote the defaultDisplayName
        // that was inferred from the catalog item name.
        if (Strings.isBlank(getConfig(DEFAULT_DISPLAY_NAME))) {
            setDefaultDisplayName("Application ("+getId()+")");
        }
        super.init();
    }
    
}
