/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.policy.followthesun;

import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.brooklyn.api.location.Location;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FollowTheSunParameters {
    private static final Logger LOG = LoggerFactory.getLogger(FollowTheSunParameters.class);
    public double triggerPercentTotal = 0.3;
    public double triggerDeltaAbovePercentTotal = 0.0;
    public double triggerAbsoluteTotal = 2.0;
    public double triggerPercentMajority = 0.2;
    public double triggerDeltaAbovePercentMajority = 1.0;
    public double triggerAbsoluteMajority = 4.0;
    public Set<Location> excludedLocations = new LinkedHashSet<Location>();

    private FollowTheSunParameters() {
    }

    public static FollowTheSunParameters newDefault() {
        return new FollowTheSunParameters();
    }

    private static double parseDouble(String text, double defaultValue) {
        try {
            double d = Double.parseDouble(text);
            if (!Double.isNaN(d)) {
                return d;
            }
        }
        catch (Exception e) {
            LOG.warn("Illegal double value '" + text + "', using default " + defaultValue + ": " + e, (Throwable)e);
        }
        return defaultValue;
    }

    private static String[] parseCommaSeparatedList(String csv) {
        if (csv == null || csv.trim().length() == 0) {
            return new String[0];
        }
        return csv.split(",");
    }

    public boolean isTriggered(double highest, double total, double nextHighest, double current) {
        if (highest <= current) {
            return false;
        }
        if (highest < total * this.triggerPercentTotal + this.triggerDeltaAbovePercentTotal) {
            return false;
        }
        if (highest < this.triggerAbsoluteTotal) {
            return false;
        }
        if (highest - current < total * this.triggerPercentMajority + this.triggerDeltaAbovePercentMajority) {
            return false;
        }
        return !(highest - current < this.triggerAbsoluteMajority);
    }

    public String toString() {
        return "Inter-geography policy params: percentTotal=" + this.triggerPercentTotal + "; deltaAbovePercentTotal=" + this.triggerDeltaAbovePercentTotal + "; absoluteTotal=" + this.triggerAbsoluteTotal + "; percentMajority=" + this.triggerPercentMajority + "; deltaAbovePercentMajority=" + this.triggerDeltaAbovePercentMajority + "; absoluteMajority=" + this.triggerAbsoluteMajority;
    }
}

