/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.domain;

import com.google.common.base.Preconditions;

public class UserIdGroupPair
implements Comparable<UserIdGroupPair> {
    private final String userId;
    private final String groupName;

    public UserIdGroupPair(String userId, String groupName) {
        this.userId = (String)Preconditions.checkNotNull((Object)userId, (Object)"userId");
        this.groupName = (String)Preconditions.checkNotNull((Object)groupName, (Object)"groupName");
    }

    public String toString() {
        return "[userId=" + this.userId + ", groupName=" + this.groupName + "]";
    }

    @Override
    public int compareTo(UserIdGroupPair o) {
        return this == o ? 0 : this.getUserId().compareTo(o.getUserId());
    }

    public String getUserId() {
        return this.userId;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.groupName == null ? 0 : this.groupName.hashCode());
        result = 31 * result + (this.userId == null ? 0 : this.userId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UserIdGroupPair other = (UserIdGroupPair)obj;
        if (this.groupName == null ? other.groupName != null : !this.groupName.equals(other.groupName)) {
            return false;
        }
        return !(this.userId == null ? other.userId != null : !this.userId.equals(other.userId));
    }
}

