/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.java;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.entity.java.JavaAppUtils;
import org.apache.brooklyn.entity.java.VanillaJavaApp;
import org.apache.brooklyn.entity.java.VanillaJavaAppDriver;
import org.apache.brooklyn.entity.java.VanillaJavaAppSshDriver;
import org.apache.brooklyn.entity.software.base.SoftwareProcessImpl;
import org.apache.brooklyn.feed.jmx.JmxFeed;
import org.apache.brooklyn.util.core.flags.SetFromFlag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VanillaJavaAppImpl
extends SoftwareProcessImpl
implements VanillaJavaApp {
    private static final Logger log = LoggerFactory.getLogger(VanillaJavaApp.class);
    @SetFromFlag
    protected long jmxPollPeriod;
    protected JmxFeed jmxFeed;

    @Override
    public String getMainClass() {
        return (String)this.getConfig(MAIN_CLASS);
    }

    @Override
    public List<String> getClasspath() {
        return (List)this.getConfig(CLASSPATH);
    }

    @Override
    public List<String> getClasspathFiles() {
        return (List)this.getAttribute(CLASSPATH_FILES);
    }

    @Override
    public Map getJvmDefines() {
        return (Map)this.getConfig(JVM_DEFINES);
    }

    @Override
    public List getJvmXArgs() {
        return (List)this.getConfig(JVM_XARGS);
    }

    public void addToClasspath(String url) {
        List cp = (List)this.getConfig(CLASSPATH);
        ArrayList<String> newCP = new ArrayList<String>();
        if (cp != null) {
            newCP.addAll(cp);
        }
        newCP.add(url);
        this.config().set(CLASSPATH, newCP);
    }

    public void addToClasspath(Collection<String> urls) {
        List cp = (List)this.getConfig(CLASSPATH);
        ArrayList<String> newCP = new ArrayList<String>();
        if (cp != null) {
            newCP.addAll(cp);
        }
        newCP.addAll(urls);
        this.config().set(CLASSPATH, newCP);
    }

    @Override
    protected void connectSensors() {
        super.connectSensors();
        if (((VanillaJavaAppDriver)this.getDriver()).isJmxEnabled()) {
            this.jmxPollPeriod = this.jmxPollPeriod > 0L ? this.jmxPollPeriod : 3000L;
            this.jmxFeed = JavaAppUtils.connectMXBeanSensors((Entity)this, this.jmxPollPeriod);
        }
        this.connectServiceUpIsRunning();
    }

    @Override
    public void disconnectSensors() {
        super.disconnectSensors();
        this.disconnectServiceUpIsRunning();
        if (this.jmxFeed != null) {
            this.jmxFeed.stop();
        }
    }

    public Class<? extends VanillaJavaAppDriver> getDriverInterface() {
        return VanillaJavaAppDriver.class;
    }

    @Override
    public String getRunDir() {
        VanillaJavaAppSshDriver driver = (VanillaJavaAppSshDriver)this.getDriver();
        return driver != null ? driver.getRunDir() : null;
    }

    @Override
    public void kill() {
        this.getDriver().kill();
    }

    static {
        JavaAppUtils.init();
    }
}

