/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.http.executor;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.io.InputStream;
import org.apache.brooklyn.util.http.executor.HttpResponse;
import org.apache.brooklyn.util.stream.Streams;

@Beta
public class HttpResponseImpl
implements HttpResponse {
    private final int code;
    private final String reasonPhrase;
    private final Multimap<String, String> headers;
    private final long contentLength;
    private final InputStream content;

    protected HttpResponseImpl(HttpResponse.Builder builder) {
        this.code = builder.code;
        this.reasonPhrase = builder.reasonPhrase;
        this.headers = (Multimap)Preconditions.checkNotNull(builder.headers, (Object)"headers");
        this.contentLength = builder.contentLength;
        this.content = builder.content;
    }

    @Override
    public void close() throws IOException {
        if (this.content != null) {
            Streams.closeQuietly(this.content);
        }
    }

    @Override
    public int code() {
        return this.code;
    }

    @Override
    public String reasonPhrase() {
        return this.reasonPhrase;
    }

    @Override
    public Multimap<String, String> headers() {
        return this.headers;
    }

    @Override
    public long getContentLength() {
        return this.contentLength;
    }

    @Override
    public InputStream getContent() {
        return this.content;
    }
}

