/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.userauth.keyprovider;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.security.PublicKey;
import net.schmizz.sshj.common.Base64;
import net.schmizz.sshj.common.Buffer;
import net.schmizz.sshj.common.Factory;
import net.schmizz.sshj.common.KeyType;
import net.schmizz.sshj.userauth.keyprovider.FileKeyProvider;
import net.schmizz.sshj.userauth.keyprovider.PKCS8KeyFile;

public class OpenSSHKeyFile
extends PKCS8KeyFile {
    private PublicKey pubKey;

    @Override
    public PublicKey getPublic() throws IOException {
        return this.pubKey != null ? this.pubKey : super.getPublic();
    }

    @Override
    public void init(File location) {
        File f = new File(location + ".pub");
        if (f.exists()) {
            try {
                this.initPubKey(new FileReader(f));
            }
            catch (IOException e) {
                this.log.warn("Error reading public key file: {}", (Object)e.toString());
            }
        }
        super.init(location);
    }

    @Override
    public void init(String privateKey, String publicKey) {
        if (publicKey != null) {
            this.initPubKey(new StringReader(publicKey));
        }
        super.init(privateKey, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initPubKey(Reader publicKey) {
        try {
            BufferedReader br = new BufferedReader(publicKey);
            try {
                String keydata = br.readLine();
                if (keydata != null) {
                    String[] parts = keydata.trim().split(" ");
                    assert (parts.length >= 2);
                    this.type = KeyType.fromString(parts[0]);
                    this.pubKey = new Buffer.PlainBuffer(Base64.decode(parts[1])).readPublicKey();
                }
            }
            finally {
                br.close();
            }
        }
        catch (IOException e) {
            this.log.warn("Error reading public key: {}", (Object)e.toString());
        }
    }

    public static class Factory
    implements Factory.Named<FileKeyProvider> {
        @Override
        public FileKeyProvider create() {
            return new OpenSSHKeyFile();
        }

        @Override
        public String getName() {
            return "OpenSSH";
        }
    }
}

