/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.loaders;

import com.google.common.base.Charsets;
import com.google.common.cache.CacheLoader;
import com.google.common.hash.Hashing;
import com.google.common.io.BaseEncoding;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.cloudstack.domain.LoginResponse;
import org.jclouds.cloudstack.features.SessionApi;
import org.jclouds.domain.Credentials;

@Singleton
public class LoginWithPasswordCredentials
extends CacheLoader<Credentials, LoginResponse> {
    private final SessionApi client;

    @Inject
    public LoginWithPasswordCredentials(SessionApi client) {
        this.client = client;
    }

    public LoginResponse load(Credentials input) {
        String username = input.identity;
        String domain = "";
        if (username.indexOf(47) != -1) {
            domain = username.substring(0, username.lastIndexOf(47));
            username = username.substring(username.lastIndexOf(47) + 1, username.length());
        }
        String hashedPassword = BaseEncoding.base16().lowerCase().encode(Hashing.md5().hashString((CharSequence)input.credential, Charsets.UTF_8).asBytes());
        return this.client.loginUserInDomainWithHashOfPassword(username, domain, hashedPassword);
    }

    public String toString() {
        return "loginWithPasswordCredentials()";
    }
}

