/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.messaging.rabbit;

import com.google.common.annotations.Beta;
import java.util.Map;
import org.apache.brooklyn.api.catalog.Catalog;
import org.apache.brooklyn.api.entity.ImplementedBy;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.sensor.AttributeSensorAndConfigKey;
import org.apache.brooklyn.core.sensor.PortAttributeSensorAndConfigKey;
import org.apache.brooklyn.core.sensor.Sensors;
import org.apache.brooklyn.entity.messaging.MessageBroker;
import org.apache.brooklyn.entity.messaging.amqp.AmqpServer;
import org.apache.brooklyn.entity.messaging.rabbit.RabbitBrokerImpl;
import org.apache.brooklyn.entity.messaging.rabbit.RabbitQueue;
import org.apache.brooklyn.entity.software.base.SoftwareProcess;
import org.apache.brooklyn.util.core.flags.SetFromFlag;

@Catalog(name="RabbitMQ Broker", description="RabbitMQ is an open source message broker software (i.e. message-oriented middleware) that implements the Advanced Message Queuing Protocol (AMQP) standard", iconUrl="classpath:///RabbitMQLogo.png")
@ImplementedBy(value=RabbitBrokerImpl.class)
public interface RabbitBroker
extends SoftwareProcess,
MessageBroker,
AmqpServer {
    @SetFromFlag(value="version")
    public static final ConfigKey<String> SUGGESTED_VERSION = ConfigKeys.newConfigKeyWithDefault((ConfigKey)SoftwareProcess.SUGGESTED_VERSION, (Object)"3.6.0");
    @SetFromFlag(value="archiveNameFormat")
    public static final ConfigKey<String> ARCHIVE_DIRECTORY_NAME_FORMAT = ConfigKeys.newConfigKeyWithDefault((ConfigKey)SoftwareProcess.ARCHIVE_DIRECTORY_NAME_FORMAT, (Object)"rabbitmq_server-%s");
    @SetFromFlag(value="downloadUrl")
    public static final AttributeSensorAndConfigKey<String, String> DOWNLOAD_URL = ConfigKeys.newSensorAndConfigKeyWithDefault((AttributeSensorAndConfigKey)SoftwareProcess.DOWNLOAD_URL, (Object)"http://www.rabbitmq.com/releases/rabbitmq-server/v${version}/rabbitmq-server-generic-unix-${version}.tar.xz");
    @SetFromFlag(value="erlangVersion")
    public static final ConfigKey<String> ERLANG_VERSION = ConfigKeys.newStringConfigKey((String)"erlang.version", (String)"Erlang runtime version", (String)"18.2");
    @SetFromFlag(value="erlangDebRepoUrl")
    public static final ConfigKey<String> ERLANG_DEB_REPO_URL = ConfigKeys.newStringConfigKey((String)"erlang.deb.repo.url", (String)"Deb file used to configure an external Erlang repository which provides up to date packages for Ubuntu/Debian", (String)"http://packages.erlang-solutions.com/erlang-solutions_1.0_all.deb");
    @SetFromFlag(value="rabbitmqConfigTemplateUrl")
    public static final ConfigKey<String> CONFIG_TEMPLATE_URL = ConfigKeys.newStringConfigKey((String)"rabbitmq.templateUrl", (String)"Template file (in freemarker format) for the rabbitmq.config config file", (String)"classpath://org/apache/brooklyn/entity/messaging/rabbit/rabbitmq.config");
    @SetFromFlag(value="amqpVersion")
    public static final AttributeSensorAndConfigKey<String, String> AMQP_VERSION = ConfigKeys.newSensorAndConfigKeyWithDefault(AmqpServer.AMQP_VERSION, (Object)"0-9-1");
    @SetFromFlag(value="managmentPort")
    public static final PortAttributeSensorAndConfigKey MANAGEMENT_PORT = ConfigKeys.newPortSensorAndConfigKey((String)"rabbitmq.management.port", (String)"Port on which management interface will be available", (Object)"15672+");
    public static final AttributeSensor<String> MANAGEMENT_URL = Sensors.newStringSensor((String)"rabbitmq.management.url", (String)"Management URL is only available if management plugin flag is true");
    @SetFromFlag(value="enableManagementPlugin")
    public static final ConfigKey<Boolean> ENABLE_MANAGEMENT_PLUGIN = ConfigKeys.newBooleanConfigKey((String)"rabbitmq.management.plugin", (String)"Management plugin will be enabled", (Boolean)false);

    public RabbitQueue createQueue(Map var1);

    @Beta
    public Map<String, String> getShellEnvironment();

    @Beta
    public String getRunDir();
}

