/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.webapp;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.annotation.Effector;
import org.apache.brooklyn.core.annotation.EffectorParam;
import org.apache.brooklyn.core.config.BasicConfigKey;
import org.apache.brooklyn.core.effector.MethodEffector;
import org.apache.brooklyn.core.sensor.BasicAttributeSensor;
import org.apache.brooklyn.entity.java.UsesJava;
import org.apache.brooklyn.entity.webapp.WebAppService;
import org.apache.brooklyn.util.core.flags.SetFromFlag;

public interface JavaWebAppService
extends WebAppService,
UsesJava {
    @SetFromFlag(value="war")
    public static final ConfigKey<String> ROOT_WAR = new BasicConfigKey(String.class, "wars.root", "WAR file to deploy as the ROOT, as URL (supporting file: and classpath: prefixes)");
    @SetFromFlag(value="wars")
    public static final ConfigKey<List<String>> NAMED_WARS = new BasicConfigKey(List.class, "wars.named", "Archive files to deploy, as URL strings (supporting file: and classpath: prefixes); context (path in user-facing URL) will be inferred by name");
    @SetFromFlag(value="warsByContext")
    public static final ConfigKey<Map<String, String>> WARS_BY_CONTEXT = new BasicConfigKey(Map.class, "wars.by.context", "Map of context keys (path in user-facing URL, typically without slashes) to archives (e.g. WARs by URL) to deploy, supporting file: and classpath: prefixes)");

    public static interface CanRedeployAll {
        public static final MethodEffector<Void> REDEPLOY_ALL = new MethodEffector(CanRedeployAll.class, "redeployAll");

        @Effector(description="Redeploys all web apps known here across the cluster (e.g. if it gets into an inconsistent state)")
        public void redeployAll();
    }

    public static interface CanDeployAndUndeploy
    extends Entity {
        public static final AttributeSensor<Set<String>> DEPLOYED_WARS = new BasicAttributeSensor(Set.class, "webapp.deployedWars", "Names of archives/contexts that are currently deployed");
        public static final MethodEffector<Void> DEPLOY = new MethodEffector(CanDeployAndUndeploy.class, "deploy");
        public static final MethodEffector<Void> UNDEPLOY = new MethodEffector(CanDeployAndUndeploy.class, "undeploy");

        @Effector(description="Deploys the given artifact, from a source URL, to a given deployment filename/context")
        public void deploy(@EffectorParam(name="url", description="URL of WAR file") String var1, @EffectorParam(name="targetName", description="context path where WAR should be deployed (/ for ROOT)") String var2);

        @Effector(description="Undeploys the given context/artifact")
        public void undeploy(@EffectorParam(name="targetName") String var1);
    }
}

