/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.proxy;

import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.net.URI;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.brooklyn.api.effector.Effector;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.Group;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.api.mgmt.TaskAdaptable;
import org.apache.brooklyn.api.policy.Policy;
import org.apache.brooklyn.api.policy.PolicySpec;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.entity.AbstractEntity;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.entity.lifecycle.ServiceStateLogic;
import org.apache.brooklyn.core.entity.trait.Startable;
import org.apache.brooklyn.core.feed.ConfigToAttributes;
import org.apache.brooklyn.entity.group.AbstractMembershipTrackingPolicy;
import org.apache.brooklyn.entity.proxy.AbstractControllerImpl;
import org.apache.brooklyn.entity.proxy.AbstractNonProvisionedController;
import org.apache.brooklyn.util.JavaGroovyEquivalents;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractNonProvisionedControllerImpl
extends AbstractEntity
implements AbstractNonProvisionedController {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractNonProvisionedControllerImpl.class);
    protected volatile boolean isActive;
    protected volatile boolean updateNeeded = true;
    protected AbstractMembershipTrackingPolicy serverPoolMemberTrackerPolicy;
    protected final Object mutex = new Object();

    public void init() {
        super.init();
        this.sensors().set(SERVER_POOL_TARGETS, (Object)ImmutableMap.of());
    }

    public void rebind() {
        super.rebind();
        if (this.sensors().get(SERVER_POOL_TARGETS) == null) {
            this.sensors().set(SERVER_POOL_TARGETS, (Object)ImmutableMap.of());
        }
    }

    @Override
    public Set<String> getServerPoolAddresses() {
        return ImmutableSet.copyOf((Iterable)Iterables.filter(((Map)this.getAttribute(SERVER_POOL_TARGETS)).values(), (Predicate)Predicates.notNull()));
    }

    @Override
    public void bind(Map<?, ?> flags) {
        if (flags.containsKey("serverPool")) {
            this.setConfigEvenIfOwned(SERVER_POOL, (Group)flags.get("serverPool"));
        }
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    public void start(Collection<? extends Location> locations) {
        this.preStart();
        this.doStart(locations);
        this.postStart();
    }

    public void stop() {
        this.preStop();
        this.doStop();
        this.postStop();
    }

    protected void preStart() {
        ConfigToAttributes.apply((Entity)this);
    }

    protected void doStart(Collection<? extends Location> locations) {
    }

    protected void postStart() {
        this.sensors().set((AttributeSensor)PROTOCOL, (Object)this.inferProtocol());
        this.sensors().set(MAIN_URI, (Object)URI.create(this.inferUrl()));
        this.sensors().set(ROOT_URL, (Object)this.inferUrl());
        this.addServerPoolMemberTrackingPolicy();
        this.isActive = true;
        this.update();
    }

    protected void preStop() {
        this.removeServerPoolMemberTrackingPolicy();
    }

    protected void doStop() {
    }

    protected void postStop() {
    }

    protected abstract String inferProtocol();

    protected abstract String inferUrl();

    protected void addServerPoolMemberTrackingPolicy() {
        Group serverPool = this.getServerPool();
        if (serverPool == null) {
            return;
        }
        if (this.serverPoolMemberTrackerPolicy != null) {
            LOG.debug("Call to addServerPoolMemberTrackingPolicy when serverPoolMemberTrackingPolicy already exists, removing and re-adding, in {}", (Object)this);
            this.removeServerPoolMemberTrackingPolicy();
        }
        for (Policy p : this.policies()) {
            if (!(p instanceof ServerPoolMemberTrackerPolicy)) continue;
            LOG.info(this + " picking up " + p + " as the tracker (already set, often due to rebind)");
            this.serverPoolMemberTrackerPolicy = (ServerPoolMemberTrackerPolicy)p;
            return;
        }
        this.serverPoolMemberTrackerPolicy = (AbstractMembershipTrackingPolicy)this.policies().add((PolicySpec)((PolicySpec)PolicySpec.create(MemberTrackingPolicy.class).displayName("Controller targets tracker")).configure((CharSequence)"group", (Object)serverPool));
        AttributeSensor hostAndPortSensor = (AttributeSensor)this.getConfig((ConfigKey.HasConfigKey)HOST_AND_PORT_SENSOR);
        AttributeSensor hostnameSensor = (AttributeSensor)this.getConfig((ConfigKey.HasConfigKey)HOSTNAME_SENSOR);
        AttributeSensor portSensor = (AttributeSensor)this.getConfig((ConfigKey.HasConfigKey)PORT_NUMBER_SENSOR);
        ImmutableSet sensorsToTrack = hostAndPortSensor != null ? ImmutableSet.of((Object)hostAndPortSensor) : ImmutableSet.of((Object)hostnameSensor, (Object)portSensor);
        this.serverPoolMemberTrackerPolicy = (AbstractMembershipTrackingPolicy)this.policies().add((PolicySpec)((PolicySpec)((PolicySpec)PolicySpec.create(ServerPoolMemberTrackerPolicy.class).displayName("Controller targets tracker")).configure((CharSequence)"group", (Object)serverPool)).configure((CharSequence)"sensorsToTrack", (Object)sensorsToTrack));
        LOG.info("Added policy {} to {}", (Object)this.serverPoolMemberTrackerPolicy, (Object)this);
        LinkedHashMap serverPoolTargets = Maps.newLinkedHashMap();
        for (Entity member : serverPool.getMembers()) {
            if (!this.belongsInServerPool(member)) continue;
            if (LOG.isTraceEnabled()) {
                LOG.trace("Done {} checkEntity {}", (Object)this, (Object)member);
            }
            String address = this.getAddressOfEntity(member);
            serverPoolTargets.put(member, address);
        }
        LOG.info("Resetting {}, server pool targets {}", new Object[]{this, serverPoolTargets});
        this.sensors().set(SERVER_POOL_TARGETS, (Object)serverPoolTargets);
    }

    protected void removeServerPoolMemberTrackingPolicy() {
        if (this.serverPoolMemberTrackerPolicy != null) {
            this.policies().remove((Policy)this.serverPoolMemberTrackerPolicy);
            this.serverPoolMemberTrackerPolicy = null;
        }
    }

    protected boolean hasServerPoolMemberTrackingPolicy() {
        if (this.serverPoolMemberTrackerPolicy != null) {
            return true;
        }
        for (Policy p : this.policies()) {
            if (!(p instanceof ServerPoolMemberTrackerPolicy)) continue;
            LOG.info(this + " picking up " + p + " as the tracker (already set, often due to rebind)");
            this.serverPoolMemberTrackerPolicy = (ServerPoolMemberTrackerPolicy)p;
            return true;
        }
        return false;
    }

    protected abstract void reconfigureService();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateNeeded() {
        Object object = this.mutex;
        synchronized (object) {
            if (this.updateNeeded) {
                return;
            }
            this.updateNeeded = true;
            LOG.debug("queueing an update-needed task for " + this + "; update will occur shortly");
            Entities.submit((Entity)this, (TaskAdaptable)Tasks.builder().displayName("update-needed").body(new Runnable(){

                @Override
                public void run() {
                    if (AbstractNonProvisionedControllerImpl.this.updateNeeded) {
                        AbstractNonProvisionedControllerImpl.this.update();
                    }
                }
            }).build());
        }
    }

    @Override
    public void update() {
        try {
            Task<?> task = this.updateAsync();
            if (task != null) {
                task.getUnchecked();
            }
            ServiceStateLogic.ServiceProblemsLogic.clearProblemsIndicator((Entity)this, (String)"update");
        }
        catch (Exception e) {
            ServiceStateLogic.ServiceProblemsLogic.updateProblemsIndicator((Entity)this, (String)"update", (Object)("update failed with: " + Exceptions.collapseText((Throwable)e)));
            throw Exceptions.propagate((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Task<?> updateAsync() {
        Object object = this.mutex;
        synchronized (object) {
            Task<?> result = null;
            if (!this.isActive()) {
                this.updateNeeded = true;
            } else {
                this.updateNeeded = false;
                LOG.debug("Updating {} in response to changes", (Object)this);
                LOG.info("Updating {}, server pool targets {}", new Object[]{this, this.getAttribute(SERVER_POOL_TARGETS)});
                this.reconfigureService();
                LOG.debug("Reloading {} in response to changes", (Object)this);
                this.invoke((Effector)RELOAD);
            }
            return result;
        }
    }

    @Override
    public void changeServerPool(String groupId) {
        Group newGroup = (Group)this.getManagementContext().getEntityManager().getEntity(groupId);
        if (newGroup == null) {
            throw new IllegalArgumentException("Group '" + groupId + "' not found");
        }
        this.config().set(SERVER_POOL, (Object)newGroup);
        if (this.hasServerPoolMemberTrackingPolicy()) {
            this.addServerPoolMemberTrackingPolicy();
        }
        this.updateNeeded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onServerPoolMemberChanged(Entity member) {
        Object object = this.mutex;
        synchronized (object) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("For {}, considering membership of {} which is in locations {}", new Object[]{this, member, member.getLocations()});
            }
            if (this.belongsInServerPool(member)) {
                this.addServerPoolMember(member);
            } else {
                this.removeServerPoolMember(member);
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("Done {} checkEntity {}", (Object)this, (Object)member);
            }
        }
    }

    protected boolean belongsInServerPool(Entity member) {
        if (!JavaGroovyEquivalents.groovyTruth((Object)member.getAttribute(Startable.SERVICE_UP))) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Members of {}, checking {}, eliminating because not up", (Object)this, (Object)member);
            }
            return false;
        }
        if (!this.getServerPool().getMembers().contains(member)) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Members of {}, checking {}, eliminating because not member", (Object)this, (Object)member);
            }
            return false;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Members of {}, checking {}, approving", (Object)this, (Object)member);
        }
        return true;
    }

    private Group getServerPool() {
        return (Group)this.getConfig(SERVER_POOL);
    }

    protected AttributeSensor<Integer> getPortNumberSensor() {
        return (AttributeSensor)this.getAttribute((AttributeSensor)PORT_NUMBER_SENSOR);
    }

    protected AttributeSensor<String> getHostnameSensor() {
        return (AttributeSensor)this.getAttribute((AttributeSensor)HOSTNAME_SENSOR);
    }

    protected AttributeSensor<String> getHostAndPortSensor() {
        return (AttributeSensor)this.getAttribute((AttributeSensor)HOST_AND_PORT_SENSOR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addServerPoolMember(Entity member) {
        Object object = this.mutex;
        synchronized (object) {
            String oldAddress = (String)((Map)this.getAttribute(SERVER_POOL_TARGETS)).get(member);
            String newAddress = this.getAddressOfEntity(member);
            if (Objects.equal((Object)newAddress, (Object)oldAddress)) {
                if (LOG.isTraceEnabled() && LOG.isTraceEnabled()) {
                    LOG.trace("Ignoring unchanged address {}", (Object)oldAddress);
                }
                return;
            }
            if (newAddress == null) {
                LOG.info("Removing from {}, member {} with old address {}, because inferred address is now null", new Object[]{this, member, oldAddress});
            } else if (oldAddress != null) {
                LOG.info("Replacing in {}, member {} with old address {}, new address {}", new Object[]{this, member, oldAddress, newAddress});
            } else {
                LOG.info("Adding to {}, new member {} with address {}", new Object[]{this, member, newAddress});
            }
            if (Objects.equal((Object)oldAddress, (Object)newAddress)) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("For {}, ignoring change in member {} because address still {}", new Object[]{this, member, newAddress});
                }
                return;
            }
            AbstractControllerImpl.MapAttribute.put(this, SERVER_POOL_TARGETS, member, newAddress);
            this.updateAsync();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeServerPoolMember(Entity member) {
        Object object = this.mutex;
        synchronized (object) {
            if (!((Map)this.getAttribute(SERVER_POOL_TARGETS)).containsKey(member)) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("For {}, not removing as don't have member {}", new Object[]{this, member});
                }
                return;
            }
            String address = (String)AbstractControllerImpl.MapAttribute.remove(this, SERVER_POOL_TARGETS, member);
            LOG.info("Removing from {}, member {} with address {}", new Object[]{this, member, address});
            this.updateAsync();
        }
    }

    protected String getAddressOfEntity(Entity member) {
        AttributeSensor<String> hostAndPortSensor = this.getHostAndPortSensor();
        if (hostAndPortSensor != null) {
            String result = (String)member.getAttribute(hostAndPortSensor);
            if (result != null) {
                return result;
            }
            LOG.error("No host:port set for {} (using attribute {}); skipping in {}", new Object[]{member, hostAndPortSensor, this});
            return null;
        }
        String ip = (String)member.getAttribute(this.getHostnameSensor());
        Integer port = (Integer)member.getAttribute(this.getPortNumberSensor());
        if (ip != null && port != null) {
            return ip + ":" + port;
        }
        LOG.error("Unable to construct hostname:port representation for {} ({}:{}); skipping in {}", new Object[]{member, ip, port, this});
        return null;
    }

    public static class ServerPoolMemberTrackerPolicy
    extends AbstractMembershipTrackingPolicy {
        protected void onEntityEvent(AbstractMembershipTrackingPolicy.EventType type, Entity entity) {
            this.defaultHighlightAction(type, entity);
            ((AbstractNonProvisionedControllerImpl)this.entity).onServerPoolMemberChanged(entity);
        }
    }

    public static class MemberTrackingPolicy
    extends AbstractMembershipTrackingPolicy {
        protected void onEntityEvent(AbstractMembershipTrackingPolicy.EventType type, Entity member) {
            this.defaultHighlightAction(type, (Entity)this.entity);
            ((AbstractNonProvisionedControllerImpl)this.entity).onServerPoolMemberChanged(member);
        }
    }
}

