/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.neutron.v2.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import java.net.URI;
import java.util.Map;
import javax.inject.Inject;
import org.jclouds.location.Region;

public class VersionAwareRegionToEndpoint
implements Function<Object, URI> {
    private final Supplier<Map<String, Supplier<URI>>> regionToEndpointSupplier;

    @Inject
    public VersionAwareRegionToEndpoint(@Region Supplier<Map<String, Supplier<URI>>> regionToEndpointSupplier) {
        this.regionToEndpointSupplier = (Supplier)Preconditions.checkNotNull(regionToEndpointSupplier, (Object)"regionToEndpointSupplier");
    }

    public URI apply(Object from) {
        Map regionToEndpoint = (Map)this.regionToEndpointSupplier.get();
        Preconditions.checkState((!regionToEndpoint.isEmpty() ? 1 : 0) != 0, (Object)"no region name to endpoint mappings configured!");
        Preconditions.checkArgument((boolean)regionToEndpoint.containsKey(from), (String)"requested location %s, which is not in the configured locations: %s", (Object[])new Object[]{from, regionToEndpoint});
        String uri = ((URI)((Supplier)regionToEndpoint.get(from)).get()).toString();
        if (uri.endsWith("/v2.0")) {
            return URI.create(uri.substring(0, uri.length() - 5));
        }
        return (URI)((Supplier)regionToEndpoint.get(from)).get();
    }
}

