/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.softlayer.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.beans.ConstructorProperties;
import java.util.Set;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.softlayer.domain.VirtualGuestBlockDeviceTemplate;

public class VirtualGuestBlockDeviceTemplateGroup {
    private final int id;
    private final String name;
    private final String globalIdentifier;
    private final int statusId;
    private final int accountId;
    private final int parentId;
    private final String summary;
    private final Set<VirtualGuestBlockDeviceTemplateGroup> children;
    private final Set<VirtualGuestBlockDeviceTemplate> blockDevices;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return VirtualGuestBlockDeviceTemplateGroup.builder().fromVirtualGuestBlockDeviceTemplateGroup(this);
    }

    @ConstructorProperties(value={"id", "name", "globalIdentifier", "statusId", "accountId", "parentId", "summary", "children", "blockDevices"})
    protected VirtualGuestBlockDeviceTemplateGroup(int id, @Nullable String name, @Nullable String globalIdentifier, int statusId, int accountId, int parentId, @Nullable String summary, @Nullable Set<VirtualGuestBlockDeviceTemplateGroup> children, @Nullable Set<VirtualGuestBlockDeviceTemplate> blockDevices) {
        this.id = id;
        this.name = name;
        this.globalIdentifier = globalIdentifier;
        this.statusId = statusId;
        this.accountId = accountId;
        this.parentId = parentId;
        this.summary = summary;
        this.children = children == null ? ImmutableSet.of() : ImmutableSet.copyOf(children);
        this.blockDevices = blockDevices == null ? ImmutableSet.of() : ImmutableSet.copyOf(blockDevices);
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getGlobalIdentifier() {
        return this.globalIdentifier;
    }

    public int getStatusId() {
        return this.statusId;
    }

    public int getAccountId() {
        return this.accountId;
    }

    public int getParentId() {
        return this.parentId;
    }

    public String getSummary() {
        return this.summary;
    }

    public Set<VirtualGuestBlockDeviceTemplateGroup> getChildren() {
        return this.children;
    }

    public Set<VirtualGuestBlockDeviceTemplate> getBlockDevices() {
        return this.blockDevices;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VirtualGuestBlockDeviceTemplateGroup that = (VirtualGuestBlockDeviceTemplateGroup)o;
        return Objects.equal((Object)this.id, (Object)that.id) && Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.globalIdentifier, (Object)that.globalIdentifier) && Objects.equal((Object)this.statusId, (Object)that.statusId) && Objects.equal((Object)this.accountId, (Object)that.accountId) && Objects.equal((Object)this.parentId, (Object)that.parentId) && Objects.equal((Object)this.summary, (Object)that.summary) && Objects.equal(this.children, that.children) && Objects.equal(this.blockDevices, that.blockDevices);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.name, this.globalIdentifier, this.statusId, this.accountId, this.parentId, this.summary, this.children, this.blockDevices});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", this.id).add("name", (Object)this.name).add("globalIdentifier", (Object)this.globalIdentifier).add("statusId", this.statusId).add("accountId", this.accountId).add("parentId", this.parentId).add("summary", (Object)this.summary).add("children", this.children).add("blockDevices", this.blockDevices).toString();
    }

    public static class Builder {
        protected int id;
        protected String name;
        protected String globalIdentifier;
        protected int statusId;
        protected int accountId;
        protected int parentId;
        protected String summary;
        protected ImmutableSet.Builder<VirtualGuestBlockDeviceTemplateGroup> children = ImmutableSet.builder();
        protected ImmutableSet.Builder<VirtualGuestBlockDeviceTemplate> blockDevices = ImmutableSet.builder();

        public Builder id(int id) {
            this.id = id;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder globalIdentifier(String globalIdentifier) {
            this.globalIdentifier = globalIdentifier;
            return this;
        }

        public Builder statusId(int statusId) {
            this.statusId = statusId;
            return this;
        }

        public Builder accountId(int accountId) {
            this.accountId = accountId;
            return this;
        }

        public Builder parentId(int parentId) {
            this.parentId = parentId;
            return this;
        }

        public Builder summary(String summary) {
            this.summary = summary;
            return this;
        }

        public Builder children(Iterable<VirtualGuestBlockDeviceTemplateGroup> children) {
            this.children.addAll((Iterable)Preconditions.checkNotNull(children, (Object)"children"));
            return this;
        }

        public Builder children(VirtualGuestBlockDeviceTemplateGroup ... in) {
            return this.children((Iterable<VirtualGuestBlockDeviceTemplateGroup>)ImmutableSet.copyOf((Object[])((Object[])Preconditions.checkNotNull((Object)in, (Object)"children"))));
        }

        public Builder blockDevices(Set<VirtualGuestBlockDeviceTemplate> blockDevices) {
            this.blockDevices.addAll((Iterable)Preconditions.checkNotNull(blockDevices, (Object)"blockDevices"));
            return this;
        }

        public Builder blockDevices(VirtualGuestBlockDeviceTemplate ... in) {
            return this.blockDevices((Set<VirtualGuestBlockDeviceTemplate>)ImmutableSet.copyOf((Object[])((Object[])Preconditions.checkNotNull((Object)in, (Object)"blockDevices"))));
        }

        public VirtualGuestBlockDeviceTemplateGroup build() {
            return new VirtualGuestBlockDeviceTemplateGroup(this.id, this.name, this.globalIdentifier, this.statusId, this.accountId, this.parentId, this.summary, (Set<VirtualGuestBlockDeviceTemplateGroup>)this.children.build(), (Set<VirtualGuestBlockDeviceTemplate>)this.blockDevices.build());
        }

        public Builder fromVirtualGuestBlockDeviceTemplateGroup(VirtualGuestBlockDeviceTemplateGroup in) {
            return this.id(in.getId()).name(in.getName()).statusId(in.getStatusId()).accountId(in.getAccountId()).parentId(in.getParentId()).summary(in.getSummary()).children(in.getChildren()).blockDevices(in.getBlockDevices());
        }
    }
}

