/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.rest.domain;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.google.common.base.Objects;
import org.apache.brooklyn.api.typereg.RegisteredType;
import org.apache.brooklyn.rest.domain.TypeSummary;

public class TypeDetail
extends TypeSummary {
    private TypeImplementationPlanSummary plan;

    TypeDetail() {
        this.plan = null;
    }

    public TypeDetail(RegisteredType t) {
        super(t);
        this.plan = new TypeImplementationPlanSummary(t.getPlan());
    }

    public TypeImplementationPlanSummary getPlan() {
        return this.plan;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.plan == null ? 0 : this.plan.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TypeDetail other = (TypeDetail)obj;
        return !(this.plan == null ? other.plan != null : !this.plan.equals(other.plan));
    }

    public static class TypeImplementationPlanSummary {
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        private String format;
        private Object data;

        private TypeImplementationPlanSummary() {
        }

        private TypeImplementationPlanSummary(RegisteredType.TypeImplementationPlan p) {
            this.format = p.getPlanFormat();
            this.data = p.getPlanData();
        }

        public String getFormat() {
            return this.format;
        }

        public Object getData() {
            return this.data;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.format, this.data});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TypeImplementationPlanSummary other = (TypeImplementationPlanSummary)obj;
            if (!Objects.equal((Object)this.data, (Object)other.data)) {
                return false;
            }
            return Objects.equal((Object)this.format, (Object)other.format);
        }
    }
}

