/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.features;

import com.google.common.collect.Multimap;
import java.util.Map;
import java.util.Set;
import javax.inject.Named;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import org.jclouds.Fallbacks;
import org.jclouds.aws.filters.FormSigner;
import org.jclouds.ec2.binders.BindFiltersToIndexedFormParams;
import org.jclouds.ec2.binders.BindUserGroupsToIndexedFormParams;
import org.jclouds.ec2.binders.BindUserIdsToIndexedFormParams;
import org.jclouds.ec2.domain.Image;
import org.jclouds.ec2.domain.Permission;
import org.jclouds.ec2.options.CreateImageOptions;
import org.jclouds.ec2.options.DescribeImagesOptions;
import org.jclouds.ec2.options.RegisterImageBackedByEbsOptions;
import org.jclouds.ec2.options.RegisterImageOptions;
import org.jclouds.ec2.xml.BlockDeviceMappingHandler;
import org.jclouds.ec2.xml.DescribeImagesResponseHandler;
import org.jclouds.ec2.xml.ImageIdHandler;
import org.jclouds.ec2.xml.PermissionHandler;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.location.functions.RegionToEndpointOrProviderIfNull;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.EndpointParam;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.FormParams;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.VirtualHost;
import org.jclouds.rest.annotations.XMLResponseParser;

@RequestFilters(value={FormSigner.class})
@VirtualHost
public interface AMIApi {
    @Named(value="DescribeImages")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"DescribeImages"})
    @XMLResponseParser(value=DescribeImagesResponseHandler.class)
    @Fallback(value=Fallbacks.EmptySetOnNotFoundOr404.class)
    public Set<? extends Image> describeImagesInRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, DescribeImagesOptions ... var2);

    @Named(value="DescribeImages")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"DescribeImages"})
    @XMLResponseParser(value=DescribeImagesResponseHandler.class)
    @Fallback(value=Fallbacks.EmptySetOnNotFoundOr404.class)
    public Set<? extends Image> describeImagesInRegionWithFilter(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, @BinderParam(value=BindFiltersToIndexedFormParams.class) Multimap<String, String> var2, DescribeImagesOptions ... var3);

    @Named(value="CreateImage")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"CreateImage"})
    @XMLResponseParser(value=ImageIdHandler.class)
    public String createImageInRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, @FormParam(value="Name") String var2, @FormParam(value="InstanceId") String var3, CreateImageOptions ... var4);

    @Named(value="DeregisterImage")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"DeregisterImage"})
    public void deregisterImageInRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, @FormParam(value="ImageId") String var2);

    @Named(value="RegisterImage")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"RegisterImage"})
    @XMLResponseParser(value=ImageIdHandler.class)
    public String registerImageFromManifestInRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, @FormParam(value="Name") String var2, @FormParam(value="ImageLocation") String var3, RegisterImageOptions ... var4);

    @Named(value="RegisterImage")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action", "RootDeviceName", "BlockDeviceMapping.0.DeviceName"}, values={"RegisterImage", "/dev/sda1", "/dev/sda1"})
    @XMLResponseParser(value=ImageIdHandler.class)
    public String registerUnixImageBackedByEbsInRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, @FormParam(value="Name") String var2, @FormParam(value="BlockDeviceMapping.0.Ebs.SnapshotId") String var3, RegisterImageBackedByEbsOptions ... var4);

    @Named(value="ResetImageAttribute")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action", "Attribute"}, values={"ResetImageAttribute", "launchPermission"})
    public void resetLaunchPermissionsOnImageInRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, @FormParam(value="ImageId") String var2);

    @Named(value="ModifyImageAttribute")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action", "OperationType", "Attribute"}, values={"ModifyImageAttribute", "add", "launchPermission"})
    public void addLaunchPermissionsToImageInRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, @BinderParam(value=BindUserIdsToIndexedFormParams.class) Iterable<String> var2, @BinderParam(value=BindUserGroupsToIndexedFormParams.class) Iterable<String> var3, @FormParam(value="ImageId") String var4);

    @Named(value="ModifyImageAttribute")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action", "OperationType", "Attribute"}, values={"ModifyImageAttribute", "remove", "launchPermission"})
    public void removeLaunchPermissionsFromImageInRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, @BinderParam(value=BindUserIdsToIndexedFormParams.class) Iterable<String> var2, @BinderParam(value=BindUserGroupsToIndexedFormParams.class) Iterable<String> var3, @FormParam(value="ImageId") String var4);

    @Named(value="DescribeImageAttribute")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action", "Attribute"}, values={"DescribeImageAttribute", "launchPermission"})
    @XMLResponseParser(value=PermissionHandler.class)
    public Permission getLaunchPermissionForImageInRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, @FormParam(value="ImageId") String var2);

    @Named(value="DescribeImageAttribute")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action", "Attribute"}, values={"DescribeImageAttribute", "blockDeviceMapping"})
    @XMLResponseParser(value=BlockDeviceMappingHandler.class)
    public Map<String, Image.EbsBlockDevice> getBlockDeviceMappingsForImageInRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, @FormParam(value="ImageId") String var2);
}

