/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.software.base;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.reflect.TypeToken;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.location.PortRange;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.entity.EntityInternal;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.collections.MutableSet;
import org.apache.brooklyn.util.core.flags.TypeCoercions;
import org.apache.brooklyn.util.guava.Maybe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InboundPortsUtils {
    private static final Logger log = LoggerFactory.getLogger(InboundPortsUtils.class);

    public static Collection<Integer> getRequiredOpenPorts(Entity entity, Boolean portsAutoInfer, String portRegex) {
        return InboundPortsUtils.getRequiredOpenPorts(entity, ImmutableSet.of(), portsAutoInfer, portRegex);
    }

    public static Collection<Integer> getRequiredOpenPorts(Entity entity, Set<ConfigKey<?>> extraConfigKeys, Boolean portsAutoInfer, String portRegex) {
        MutableSet ports = MutableSet.of();
        if (portsAutoInfer == null || portsAutoInfer.booleanValue()) {
            HashSet configKeys = Sets.newHashSet(extraConfigKeys);
            configKeys.addAll(entity.getEntityType().getConfigKeys());
            MutableMap configuredConfigKeys = MutableMap.copyOf((Map)((EntityInternal)entity).config().getBag().getAllConfigAsConfigKeyMap());
            configKeys.addAll(configuredConfigKeys.keySet());
            if (portRegex == null) {
                portRegex = ".*\\.port";
            }
            Pattern portsPattern = Pattern.compile(portRegex);
            for (ConfigKey k : configKeys) {
                PortRange p;
                Object value;
                Maybe maybePortRange;
                if (!InboundPortsUtils.isAssignableFromPortConfigKey(configuredConfigKeys, k) && !portsPattern.matcher(k.getName()).matches() || !(maybePortRange = TypeCoercions.tryCoerce((Object)(value = entity.config().get(k)), (TypeToken)new TypeToken<PortRange>(){})).isPresentAndNonNull() || (p = (PortRange)maybePortRange.get()) == null || p.isEmpty()) continue;
                ports.add(p.iterator().next());
            }
        }
        log.debug("getRequiredOpenPorts detected default {} for {}", (Object)ports, (Object)entity);
        return ports;
    }

    private static boolean isAssignableFromPortConfigKey(Map<ConfigKey<?>, ?> configuredConfigKeys, ConfigKey<?> configKey) {
        return PortRange.class.isAssignableFrom(configKey.getType()) || configuredConfigKeys.get(configKey) instanceof PortRange;
    }
}

