/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.core.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonStreamContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.DefaultSerializerProvider;
import com.fasterxml.jackson.databind.ser.SerializerFactory;
import java.io.IOException;
import org.apache.brooklyn.util.core.json.ErrorAndToStringUnknownTypeSerializer;
import org.apache.brooklyn.util.exceptions.Exceptions;

final class ConfigurableSerializerProvider
extends DefaultSerializerProvider {
    private static final long serialVersionUID = 6094990395562170217L;
    protected JsonSerializer<Object> unknownTypeSerializer;

    public ConfigurableSerializerProvider() {
    }

    public DefaultSerializerProvider createInstance(SerializationConfig config, SerializerFactory jsf) {
        return new ConfigurableSerializerProvider(config, this, jsf);
    }

    public ConfigurableSerializerProvider(SerializationConfig config, ConfigurableSerializerProvider src, SerializerFactory jsf) {
        super((SerializerProvider)src, config, jsf);
        this.unknownTypeSerializer = src.unknownTypeSerializer;
    }

    public JsonSerializer<Object> getUnknownTypeSerializer(Class<?> unknownType) {
        if (this.unknownTypeSerializer != null) {
            return this.unknownTypeSerializer;
        }
        return super.getUnknownTypeSerializer(unknownType);
    }

    public void setUnknownTypeSerializer(JsonSerializer<Object> unknownTypeSerializer) {
        this.unknownTypeSerializer = unknownTypeSerializer;
    }

    public void serializeValue(JsonGenerator jgen, Object value) throws IOException {
        JsonStreamContext ctxt = jgen.getOutputContext();
        try {
            super.serializeValue(jgen, value);
        }
        catch (Exception e) {
            this.onSerializationException(ctxt, jgen, value, e);
        }
    }

    public void serializeValue(JsonGenerator jgen, Object value, JavaType rootType) throws IOException {
        JsonStreamContext ctxt = jgen.getOutputContext();
        try {
            super.serializeValue(jgen, value, rootType);
        }
        catch (Exception e) {
            this.onSerializationException(ctxt, jgen, value, e);
        }
    }

    protected void onSerializationException(JsonStreamContext ctxt, JsonGenerator jgen, Object value, Exception e) throws IOException {
        Exceptions.propagateIfFatal((Throwable)e);
        JsonSerializer<Object> unknownTypeSerializer = this.getUnknownTypeSerializer(value.getClass());
        if (unknownTypeSerializer instanceof ErrorAndToStringUnknownTypeSerializer) {
            ((ErrorAndToStringUnknownTypeSerializer)unknownTypeSerializer).serializeFromError(ctxt, e, value, jgen, (SerializerProvider)this);
        } else {
            unknownTypeSerializer.serialize(value, jgen, (SerializerProvider)this);
        }
    }
}

