/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.mgmt.persist;

import java.util.List;
import java.util.Map;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.time.Duration;

public class PersistenceActivityMetrics {
    static final int MAX_ERRORS = 200;
    long count = 0L;
    long failureCount = 0L;
    Long lastSuccessTime;
    Long lastDuration;
    Long lastFailureTime;
    List<Map<String, Object>> errorMessages = MutableList.of();

    public void noteSuccess(Duration duration) {
        ++this.count;
        this.lastSuccessTime = System.currentTimeMillis();
        this.lastDuration = duration.toMilliseconds();
    }

    public void noteFailure(Duration duration) {
        ++this.count;
        ++this.failureCount;
        this.lastFailureTime = System.currentTimeMillis();
        this.lastDuration = duration != null ? duration.toMilliseconds() : -1L;
    }

    public void noteError(String error) {
        this.noteErrorObject(error);
    }

    public void noteError(List<?> error) {
        this.noteErrorObject(error);
    }

    protected synchronized void noteErrorObject(Object error) {
        this.errorMessages.add(0, (Map<String, Object>)MutableMap.of((Object)"error", (Object)error, (Object)"timestamp", (Object)System.currentTimeMillis()));
        while (this.errorMessages.size() > 200) {
            this.errorMessages.remove(this.errorMessages.size() - 1);
        }
    }

    public synchronized Map<String, Object> asMap() {
        MutableMap result = MutableMap.of();
        result.put("count", this.count);
        result.put("lastSuccessTimeUtc", this.lastSuccessTime);
        result.put("lastSuccessTimeMillisSince", this.since(this.lastSuccessTime));
        result.put("lastDuration", this.lastDuration);
        result.put("failureCount", this.failureCount);
        result.put("lastFailureTimeUtc", this.lastFailureTime);
        result.put("lastFailureTimeMillisSince", this.since(this.lastFailureTime));
        result.put("errorMessages", MutableList.copyOf(this.errorMessages));
        return result;
    }

    private Long since(Long time) {
        if (time == null) {
            return null;
        }
        return System.currentTimeMillis() - time;
    }
}

