/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.location;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import java.util.Map;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.location.LocationRegistry;
import org.apache.brooklyn.api.location.LocationResolver;
import org.apache.brooklyn.api.location.LocationSpec;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.typereg.RegisteredType;
import org.apache.brooklyn.core.location.BasicLocationRegistry;
import org.apache.brooklyn.core.typereg.BundleUpgradeParser;
import org.apache.brooklyn.util.text.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CatalogLocationResolver
implements LocationResolver {
    private static final Logger log = LoggerFactory.getLogger(CatalogLocationResolver.class);
    public static final String NAME = "brooklyn.catalog";
    private ManagementContext managementContext;

    public void init(ManagementContext managementContext) {
        this.managementContext = (ManagementContext)Preconditions.checkNotNull((Object)managementContext, (Object)"managementContext");
    }

    public boolean isEnabled() {
        return true;
    }

    public LocationSpec<? extends Location> newLocationSpecFromString(String spec, Map<?, ?> locationFlags, LocationRegistry registry) {
        String id = spec.substring(NAME.length() + 1);
        RegisteredType item = this.managementContext.getTypeRegistry().get(BundleUpgradeParser.CatalogUpgrades.getTypeUpgradedIfNecessary(this.managementContext, id));
        if (item.isDisabled()) {
            throw new IllegalStateException("Illegal use of disabled catalog item " + item.getSymbolicName() + ":" + item.getVersion());
        }
        if (item.isDeprecated()) {
            log.warn("Use of deprecated catalog item " + item.getSymbolicName() + ":" + item.getVersion());
        }
        LocationSpec origLocSpec = (LocationSpec)this.managementContext.getTypeRegistry().createSpec(item, null, LocationSpec.class);
        return (LocationSpec)LocationSpec.create((LocationSpec)origLocSpec).configure(locationFlags);
    }

    public String getPrefix() {
        return NAME;
    }

    public boolean accepts(String spec, LocationRegistry registry) {
        if (BasicLocationRegistry.isResolverPrefixForSpec(this, spec, false)) {
            return true;
        }
        return registry.getDefinedLocationByName(spec) != null;
    }

    @Beta
    public static boolean isLegacyWrappedReference(String spec) {
        if (spec == null) {
            return false;
        }
        return spec.startsWith("brooklyn.catalog:");
    }

    @Beta
    public static String createLegacyWrappedReference(String id) {
        return "brooklyn.catalog:" + id;
    }

    @Beta
    public static String unwrapLegacyWrappedReference(String id) {
        return Strings.removeFromStart((String)id, (String)"brooklyn.catalog:");
    }
}

