/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.ui.modularity.metadata.registry;

import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.apache.brooklyn.ui.modularity.metadata.registry.UiMetadataRegistry;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
public class RestUiMetadataRegistry {
    private static final Logger logger = LoggerFactory.getLogger(RestUiMetadataRegistry.class);
    private UiMetadataRegistry metadataRegistry;

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    public Map get(@QueryParam(value="id") String id, @QueryParam(value="type") String type) {
        if (StringUtils.isNotEmpty((CharSequence)id) && StringUtils.isNotEmpty((CharSequence)type)) {
            return this.metadataRegistry.getByTypeAndId(type, id);
        }
        if (StringUtils.isNotEmpty((CharSequence)id)) {
            return this.metadataRegistry.getById(id);
        }
        if (StringUtils.isNotEmpty((CharSequence)type)) {
            return this.metadataRegistry.getByType(type);
        }
        return this.metadataRegistry.getAll();
    }

    public void setMetadataRegistry(UiMetadataRegistry metadataRegistry) {
        this.metadataRegistry = metadataRegistry;
    }
}

