/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.database.mysql;

import com.google.common.collect.ImmutableMap;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.api.entity.drivers.EntityDriver;
import org.apache.brooklyn.api.location.OsDetails;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.api.mgmt.TaskFactory;
import org.apache.brooklyn.core.effector.EffectorTasks;
import org.apache.brooklyn.core.effector.ssh.SshEffectorTasks;
import org.apache.brooklyn.core.entity.Attributes;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.entity.database.DatastoreMixins;
import org.apache.brooklyn.entity.database.mysql.MySqlDriver;
import org.apache.brooklyn.entity.database.mysql.MySqlNode;
import org.apache.brooklyn.entity.database.mysql.MySqlNodeImpl;
import org.apache.brooklyn.entity.software.base.AbstractSoftwareProcessSshDriver;
import org.apache.brooklyn.location.ssh.SshMachineLocation;
import org.apache.brooklyn.util.JavaGroovyEquivalents;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.task.DynamicTasks;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.core.task.ssh.SshTasks;
import org.apache.brooklyn.util.core.task.system.ProcessTaskWrapper;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.io.FileUtil;
import org.apache.brooklyn.util.net.Urls;
import org.apache.brooklyn.util.os.Os;
import org.apache.brooklyn.util.ssh.BashCommands;
import org.apache.brooklyn.util.stream.Streams;
import org.apache.brooklyn.util.text.ComparableVersion;
import org.apache.brooklyn.util.text.Identifiers;
import org.apache.brooklyn.util.text.Strings;
import org.apache.brooklyn.util.time.CountdownTimer;
import org.apache.brooklyn.util.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySqlSshDriver
extends AbstractSoftwareProcessSshDriver
implements MySqlDriver {
    public static final Logger log = LoggerFactory.getLogger(MySqlSshDriver.class);

    public MySqlSshDriver(MySqlNodeImpl entity, SshMachineLocation machine) {
        super((EntityLocal)entity, machine);
        entity.sensors().set(Attributes.LOG_FILE_LOCATION, (Object)this.getLogFile());
    }

    public String getOsTag() {
        OsDetails os = this.getLocation().getOsDetails();
        if (os == null) {
            return "linux-glibc2.5-x86_64";
        }
        if (os.isMac()) {
            String osp1;
            String string = os.getVersion() == null ? "osx10.8" : (osp1 = new ComparableVersion(os.getVersion()).isGreaterThanOrEqualTo("10.9") ? "osx10.9" : "osx10.8");
            if (!os.is64bit()) {
                throw new IllegalStateException("Only 64 bit MySQL build is available for OS X");
            }
            return osp1 + "-x86_64";
        }
        String osp1 = "linux-glibc2.5";
        String osp2 = os.is64bit() ? "x86_64" : "i686";
        return osp1 + "-" + osp2;
    }

    public String getBaseDir() {
        return this.getExpandedInstallDir();
    }

    public String getDataDir() {
        String result = (String)this.entity.getConfig(MySqlNode.DATA_DIR);
        return Strings.isBlank((CharSequence)result) ? "." : result;
    }

    public String getLogFile() {
        return Urls.mergePaths((String[])new String[]{this.getRunDir(), "console.log"});
    }

    public String getConfigFile() {
        return "mymysql.cnf";
    }

    public String getMajorVersion() {
        return ((String)this.getEntity().config().get(MySqlNode.SUGGESTED_VERSION)).replaceAll("(\\d+\\.\\d+)\\.\\d+", "$1");
    }

    public String getDefaultUnpackedDirectoryName() {
        return Strings.removeAllFromEnd((String)this.resolver.getFilename(), (String[])new String[]{".tar.gz"});
    }

    public void prepare() {
        this.resolver = Entities.newDownloader((EntityDriver)this);
        String unpackedDirectoryName = this.resolver.getUnpackedDirectoryName(this.getDefaultUnpackedDirectoryName());
        this.setExpandedInstallDir(Os.mergePaths((String[])new String[]{this.getInstallDir(), unpackedDirectoryName}));
    }

    public void install() {
        List urls = this.resolver.getTargets();
        String saveAs = this.resolver.getFilename();
        LinkedList<String> commands = new LinkedList<String>();
        commands.add(BashCommands.INSTALL_TAR);
        commands.add(BashCommands.INSTALL_CURL);
        commands.add("echo installing extra packages");
        commands.add(BashCommands.installPackage((Map)ImmutableMap.of((Object)"yum", (Object)"libgcc_s.so.1"), null));
        commands.add(BashCommands.installPackage((Map)ImmutableMap.of((Object)"yum", (Object)"libaio.so.1 libncurses.so.5", (Object)"apt", (Object)"libaio1 libaio-dev"), null));
        commands.add(BashCommands.installPackage((Map)ImmutableMap.of((Object)"yum", (Object)"perl", (Object)"apt", (Object)"perl"), null));
        commands.add(BashCommands.installPackage((Map)ImmutableMap.of((Object)"yum", (Object)"perl-Data-Dumper", (Object)"apt", (Object)"libdata-dumper-concise-perl"), null));
        commands.add(BashCommands.installPackage((Map)ImmutableMap.of((Object)"yum", (Object)"libaio", (Object)"apt", (Object)"ia32-libs"), null));
        commands.add("echo finished installing extra packages");
        commands.addAll(BashCommands.commandsToDownloadUrlsAs((List)urls, (String)saveAs));
        commands.add(String.format("tar xfvz %s", saveAs));
        this.newScript((String)"installing").body.append(commands).execute();
    }

    public MySqlNodeImpl getEntity() {
        return (MySqlNodeImpl)super.getEntity();
    }

    public int getPort() {
        return this.getEntity().getPort();
    }

    public String getSocketUid() {
        return this.getEntity().getSocketUid();
    }

    public String getPassword() {
        return this.getEntity().getPassword();
    }

    public void customize() {
        this.copyDatabaseConfigScript();
        this.newScript((String)"customizing").updateTaskAndFailOnNonZeroResultCode().body.append(new CharSequence[]{"chmod 600 " + this.getConfigFile(), this.getBaseDir() + "/scripts/mysql_install_db --basedir=" + this.getBaseDir() + " --datadir=" + this.getDataDir() + " --defaults-file=" + this.getConfigFile()}).execute();
        this.launch();
        Task configTask = DynamicTasks.queue((String)"execute scripts", (Runnable)new Runnable(){

            @Override
            public void run() {
                Tasks.markInessential();
                CountdownTimer timer = Duration.seconds((Number)20).countdownTimer();
                boolean hasCreationScript = MySqlSshDriver.this.copyDatabaseCreationScript();
                timer.waitForExpiryUnchecked();
                MySqlSshDriver.this.changePassword("", MySqlSshDriver.this.getPassword());
                if (hasCreationScript) {
                    MySqlSshDriver.this.executeScriptFromInstalledFileAsync("creation-script.sql").asTask().getUnchecked();
                }
            }
        });
        this.stop();
        if (configTask.isError()) {
            configTask.getUnchecked();
        }
    }

    @Override
    public void changePassword(String oldPass, String newPass) {
        DynamicTasks.queue((TaskFactory)((SshEffectorTasks.SshEffectorTaskFactory)SshEffectorTasks.ssh((String[])new String[]{"cd " + this.getRunDir(), BashCommands.alternatives((String[])new String[]{this.getBaseDir() + "/bin/mysqladmin --defaults-file=" + this.getConfigFile() + " --password=" + oldPass + " password " + newPass, this.getBaseDir() + "/bin/mysqladmin --defaults-file=" + this.getConfigFile() + " --password=" + newPass + " password " + newPass})}).summary("Checking and updating password")).requiringExitCodeZero());
    }

    protected void copyDatabaseConfigScript() {
        this.newScript("customizing").execute();
        String configScriptContents = this.processTemplate((String)this.entity.getAttribute(MySqlNode.TEMPLATE_CONFIGURATION_URL));
        StringReader configContents = new StringReader(configScriptContents);
        this.getMachine().copyTo((Reader)configContents, Urls.mergePaths((String[])new String[]{this.getRunDir(), this.getConfigFile()}));
    }

    protected boolean copyDatabaseCreationScript() {
        File templateFile;
        block8: {
            String creationScriptContents = DatastoreMixins.getDatabaseCreationScriptAsString((Entity)this.entity);
            if (creationScriptContents == null) {
                return false;
            }
            templateFile = null;
            BufferedWriter writer = null;
            try {
                templateFile = File.createTempFile("mysql", null);
                FileUtil.setFilePermissionsTo600((File)templateFile);
                writer = new BufferedWriter(new FileWriter(templateFile));
                writer.write(creationScriptContents);
                writer.flush();
                this.copyTemplate(templateFile.getAbsoluteFile(), this.getRunDir() + "/creation-script.sql");
                if (writer == null) break block8;
            }
            catch (IOException e) {
                try {
                    throw Exceptions.propagate((Throwable)e);
                }
                catch (Throwable throwable) {
                    if (writer != null) {
                        Streams.closeQuietly(writer);
                    }
                    if (templateFile != null) {
                        templateFile.delete();
                    }
                    throw throwable;
                }
            }
            Streams.closeQuietly((Closeable)writer);
        }
        if (templateFile != null) {
            templateFile.delete();
        }
        return true;
    }

    public String getMySqlServerOptionsString() {
        Map options = (Map)this.entity.getConfig(MySqlNode.MYSQL_SERVER_CONF);
        StringBuilder result = new StringBuilder();
        if (JavaGroovyEquivalents.groovyTruth((Object)options)) {
            for (Map.Entry entry : options.entrySet()) {
                result.append((String)entry.getKey());
                String value = entry.getValue().toString();
                if (!Strings.isEmpty((CharSequence)value)) {
                    result.append(" = ").append(value);
                }
                result.append('\n');
            }
        }
        return result.toString();
    }

    public void launch() {
        this.entity.sensors().set(MySqlNode.PID_FILE, (Object)(this.getRunDir() + "/" + "pid.txt"));
        this.newScript((Map)MutableMap.of((Object)"usePidFile", (Object)Boolean.valueOf((boolean)true)), (String)"launching").updateTaskAndFailOnNonZeroResultCode().body.append((CharSequence)String.format("nohup %s/bin/mysqld --defaults-file=%s --user=`whoami` > %s 2>&1 < /dev/null &", this.getBaseDir(), this.getConfigFile(), this.getLogFile())).execute();
    }

    public boolean isRunning() {
        return this.newScript((Map)MutableMap.of((Object)"usePidFile", (Object)Boolean.valueOf((boolean)false)), (String)"check-running").body.append((CharSequence)this.getStatusCmd()).execute() == 0;
    }

    public void stop() {
        this.newScript((Map)MutableMap.of((Object)"usePidFile", (Object)true), "stopping").execute();
    }

    public void kill() {
        this.newScript((Map)MutableMap.of((Object)"usePidFile", (Object)true), "killing").execute();
    }

    @Override
    public String getStatusCmd() {
        return String.format("%s/bin/mysqladmin --defaults-file=%s status", this.getBaseDir(), Urls.mergePaths((String[])new String[]{this.getRunDir(), this.getConfigFile()}));
    }

    @Override
    public ProcessTaskWrapper<Integer> executeScriptAsync(String commands) {
        String filename = "mysql-commands-" + Identifiers.makeRandomId((int)8);
        DynamicTasks.queue((TaskFactory)SshEffectorTasks.put((String)Urls.mergePaths((String[])new String[]{this.getRunDir(), filename})).contents(commands).summary("copying datastore script to execute " + filename));
        return this.executeScriptFromInstalledFileAsync(filename);
    }

    @Override
    public ProcessTaskWrapper<Integer> executeScriptFromInstalledFileAsync(String filenameAlreadyInstalledAtServer) {
        SshMachineLocation machine = EffectorTasks.getSshMachine((Entity)this.entity);
        return (ProcessTaskWrapper)DynamicTasks.queue((TaskFactory)SshTasks.newSshExecTaskFactory((SshMachineLocation)machine, (String[])new String[]{"cd " + this.getRunDir(), this.getBaseDir() + "/bin/mysql --defaults-file=" + this.getConfigFile() + " < " + filenameAlreadyInstalledAtServer}).requiringExitCodeZero().summary("executing datastore script " + filenameAlreadyInstalledAtServer));
    }

    @Override
    public ProcessTaskWrapper<Integer> dumpDatabase(String additionalOptions, String dumpDestination) {
        SshMachineLocation machine = EffectorTasks.getSshMachine((Entity)this.entity);
        return (ProcessTaskWrapper)DynamicTasks.queue((TaskFactory)SshTasks.newSshExecTaskFactory((SshMachineLocation)machine, (String[])new String[]{"cd " + this.getRunDir(), this.getBaseDir() + "/bin/mysqldump --defaults-file=" + this.getConfigFile() + " " + additionalOptions + " > " + dumpDestination}).requiringExitCodeZero().summary("Dumping database to " + dumpDestination));
    }
}

