/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.http.executor.apacheclient;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.http.HttpToolResponse;
import org.apache.brooklyn.util.http.executor.HttpResponse;
import org.apache.http.HttpEntity;
import org.apache.http.util.EntityUtils;

@Beta
public class HttpResponseWrapper
implements HttpResponse {
    private final HttpToolResponse delegate;
    private volatile transient byte[] content;
    private volatile transient Multimap<String, String> headers;

    public HttpResponseWrapper(HttpToolResponse delegate) {
        this.delegate = (HttpToolResponse)Preconditions.checkNotNull((Object)delegate, (Object)"response");
    }

    @Override
    public void close() throws IOException {
        HttpEntity entity;
        Maybe<org.apache.http.HttpResponse> apacheResponse = this.delegate.getResponse();
        if (apacheResponse.isPresent() && (entity = apacheResponse.get().getEntity()) != null) {
            EntityUtils.consumeQuietly((HttpEntity)apacheResponse.get().getEntity());
        }
    }

    @Override
    public int code() {
        return this.delegate.getResponseCode();
    }

    @Override
    public String reasonPhrase() {
        return this.delegate.getReasonPhrase();
    }

    @Override
    public Multimap<String, String> headers() {
        return this.headersImpl();
    }

    @Override
    public long getContentLength() {
        byte[] content = this.getContentImpl();
        return content == null ? -1L : (long)content.length;
    }

    @Override
    public InputStream getContent() {
        byte[] content = this.getContentImpl();
        return content == null ? null : new ByteArrayInputStream(content);
    }

    protected byte[] getContentImpl() {
        if (this.content == null) {
            this.content = this.delegate.getContent();
        }
        return this.content;
    }

    protected Multimap<String, String> headersImpl() {
        if (this.headers == null) {
            Map<String, List<String>> headerLists = this.delegate.getHeaderLists();
            ArrayListMultimap headers = ArrayListMultimap.create((int)headerLists.size(), (int)3);
            for (Map.Entry<String, List<String>> entry : headerLists.entrySet()) {
                headers.putAll((Object)entry.getKey(), (Iterable)entry.getValue());
            }
            this.headers = Multimaps.unmodifiableMultimap((Multimap)headers);
        }
        return this.headers;
    }
}

