/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.internal;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Singleton;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.jclouds.Context;
import org.jclouds.annotations.Name;
import org.jclouds.domain.Credentials;
import org.jclouds.domain.Location;
import org.jclouds.domain.LocationScope;
import org.jclouds.lifecycle.Closer;
import org.jclouds.location.Provider;
import org.jclouds.providers.ProviderMetadata;
import org.jclouds.rest.Utils;
import org.jclouds.util.Closeables2;

@Singleton
public class ContextImpl
implements Context {
    private final ProviderMetadata providerMetadata;
    private final Supplier<Credentials> creds;
    private final Utils utils;
    private final Closer closer;
    private final String name;

    @Inject
    protected ContextImpl(@Name String name, ProviderMetadata providerMetadata, @Provider Supplier<Credentials> creds, Utils utils, Closer closer) {
        this.providerMetadata = (ProviderMetadata)Preconditions.checkNotNull((Object)providerMetadata, (Object)"providerMetadata");
        this.creds = (Supplier)Preconditions.checkNotNull(creds, (Object)"creds");
        this.utils = (Utils)Preconditions.checkNotNull((Object)utils, (Object)"utils");
        this.closer = (Closer)Preconditions.checkNotNull((Object)closer, (Object)"closer");
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
    }

    @Override
    public void close() {
        Closeables2.closeQuietly(this.closer);
    }

    @Override
    public boolean isOpen() {
        return this.closer.getState() == Closer.State.AVAILABLE;
    }

    @Override
    public ProviderMetadata getProviderMetadata() {
        return this.providerMetadata;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getIdentity() {
        return ((Credentials)this.creds.get()).identity;
    }

    @Override
    public Utils utils() {
        return this.utils;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.providerMetadata, this.creds});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ContextImpl that = (ContextImpl)ContextImpl.class.cast(obj);
        return Objects.equal((Object)this.providerMetadata, (Object)that.providerMetadata) && Objects.equal(this.creds, that.creds);
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"").add("providerMetadata", (Object)this.providerMetadata).add("identity", (Object)this.getIdentity()).toString();
    }

    @Override
    public String getDescription() {
        return this.providerMetadata.getName();
    }

    @Override
    public String getId() {
        return this.providerMetadata.getId();
    }

    @Override
    public Set<String> getIso3166Codes() {
        return this.providerMetadata.getIso3166Codes();
    }

    @Override
    public Map<String, Object> getMetadata() {
        return ImmutableMap.of((Object)"endpoint", (Object)URI.create(this.providerMetadata.getEndpoint()), (Object)"apiVersion", (Object)this.providerMetadata.getApiMetadata().getVersion(), (Object)"buildVersion", (Object)this.providerMetadata.getApiMetadata().getBuildVersion().or((Object)""), (Object)"identity", (Object)this.getIdentity());
    }

    @Override
    public Location getParent() {
        return null;
    }

    @Override
    public LocationScope getScope() {
        return LocationScope.PROVIDER;
    }
}

