/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.binders;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import com.google.common.hash.Hashing;
import com.jamesmurty.utils.XMLBuilder;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.jclouds.http.HttpRequest;
import org.jclouds.io.Payload;
import org.jclouds.io.Payloads;
import org.jclouds.io.payloads.StringPayload;
import org.jclouds.rest.Binder;

public class BindIterableAsPayloadToDeleteRequest
implements Binder {
    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        String content;
        Preconditions.checkArgument((boolean)(Preconditions.checkNotNull((Object)input, (Object)"input is null") instanceof Iterable), (Object)"this binder is only valid for an Iterable");
        Preconditions.checkNotNull(request, (Object)"request is null");
        Iterable keys = (Iterable)input;
        Preconditions.checkArgument((!Iterables.isEmpty((Iterable)keys) ? 1 : 0) != 0, (Object)"The list of keys should not be empty.");
        try {
            XMLBuilder rootBuilder = XMLBuilder.create((String)"Delete");
            for (String key : keys) {
                XMLBuilder ownerBuilder = rootBuilder.elem("Object");
                XMLBuilder xMLBuilder = ownerBuilder.elem("Key").text(key);
            }
            Properties outputProperties = new Properties();
            outputProperties.put("omit-xml-declaration", "yes");
            content = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" + rootBuilder.asString(outputProperties);
        }
        catch (ParserConfigurationException pce) {
            throw Throwables.propagate((Throwable)pce);
        }
        catch (TransformerException te) {
            throw Throwables.propagate((Throwable)te);
        }
        StringPayload payload = Payloads.newStringPayload((String)content);
        payload.getContentMetadata().setContentType("text/xml");
        byte[] md5 = Hashing.md5().hashString((CharSequence)content, Charsets.UTF_8).asBytes();
        payload.getContentMetadata().setContentMD5(md5);
        request.setPayload((Payload)payload);
        return request;
    }
}

