/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.atmos.domain;

import com.google.common.base.Objects;
import java.util.Date;
import org.jclouds.atmos.domain.FileType;
import org.jclouds.javax.annotation.Nullable;

public class DirectoryEntry
implements Comparable<DirectoryEntry> {
    private final String objectid;
    private final FileType type;
    private final String objname;
    private final long size;
    @Nullable
    private final Date modifiedTime;

    @Deprecated
    public DirectoryEntry(String objectid, FileType type, String objname, long size) {
        this(objectid, type, objname, size, null);
    }

    public DirectoryEntry(String objectid, FileType type, String objname, long size, Date modifiedTime) {
        this.objectid = objectid;
        this.objname = objname;
        this.type = type;
        this.size = size;
        this.modifiedTime = modifiedTime != null ? (Date)modifiedTime.clone() : null;
    }

    public String getObjectID() {
        return this.objectid;
    }

    public String getObjectName() {
        return this.objname;
    }

    public FileType getType() {
        return this.type;
    }

    public long getSize() {
        return this.size;
    }

    public Date getModifiedTime() {
        return this.modifiedTime != null ? (Date)this.modifiedTime.clone() : null;
    }

    @Override
    public int compareTo(DirectoryEntry o) {
        if (this.getObjectName() == null) {
            return -1;
        }
        return this == o ? 0 : this.getObjectName().compareTo(o.getObjectName());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.objectid, this.objname, this.type, this.size});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DirectoryEntry other = (DirectoryEntry)obj;
        return Objects.equal((Object)this.objectid, (Object)other.objectid) && Objects.equal((Object)this.objname, (Object)other.objname) && Objects.equal((Object)((Object)this.type), (Object)((Object)other.type)) && Objects.equal((Object)this.size, (Object)other.size);
    }

    public String toString() {
        return "DirectoryEntry [type=" + (Object)((Object)this.type) + ", objectid=" + this.objectid + ", objname=" + this.objname + ", size=" + this.size + "]";
    }
}

