/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.cloudstack.CloudStackApi;
import org.jclouds.cloudstack.domain.SecurityGroup;
import org.jclouds.cloudstack.domain.Zone;
import org.jclouds.cloudstack.domain.ZoneSecurityGroupNamePortsCidrs;
import org.jclouds.cloudstack.options.AccountInDomainOptions;
import org.jclouds.cloudstack.predicates.SecurityGroupPredicates;
import org.jclouds.cloudstack.predicates.ZonePredicates;
import org.jclouds.logging.Logger;

@Singleton
public class CreateSecurityGroupIfNeeded
implements Function<ZoneSecurityGroupNamePortsCidrs, SecurityGroup> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    protected final CloudStackApi client;
    protected final Supplier<LoadingCache<String, Zone>> zoneIdToZone;
    protected final Predicate<String> jobComplete;

    @Inject
    public CreateSecurityGroupIfNeeded(CloudStackApi client, Predicate<String> jobComplete, Supplier<LoadingCache<String, Zone>> zoneIdToZone) {
        this.client = (CloudStackApi)Preconditions.checkNotNull((Object)client, (Object)"client");
        this.jobComplete = (Predicate)Preconditions.checkNotNull(jobComplete, (Object)"jobComplete");
        this.zoneIdToZone = zoneIdToZone;
    }

    public SecurityGroup apply(ZoneSecurityGroupNamePortsCidrs input) {
        Preconditions.checkNotNull((Object)input, (Object)"input");
        String zoneId = input.getZone();
        Zone zone = (Zone)((LoadingCache)this.zoneIdToZone.get()).getUnchecked((Object)zoneId);
        Preconditions.checkArgument((boolean)ZonePredicates.supportsSecurityGroups().apply((Object)zone), (String)"Security groups are required, but the zone %s does not support security groups", (Object[])new Object[]{zoneId});
        this.logger.debug(">> creating securityGroup %s", new Object[]{input});
        try {
            SecurityGroup securityGroup = this.client.getSecurityGroupApi().createSecurityGroup(input.getName());
            this.logger.debug("<< created securityGroup(%s)", new Object[]{securityGroup});
            ImmutableSet cidrs = !input.getCidrs().isEmpty() ? ImmutableSet.copyOf(input.getCidrs()) : ImmutableSet.of((Object)"0.0.0.0/0");
            for (int port : input.getPorts()) {
                this.authorizeGroupToItselfAndToTCPPortAndCidr(this.client, securityGroup, port, (Set<String>)cidrs);
            }
            return securityGroup;
        }
        catch (IllegalStateException e) {
            this.logger.trace("<< trying to find securityGroup(%s): %s", new Object[]{input, e.getMessage()});
            SecurityGroup group = this.client.getSecurityGroupApi().getSecurityGroupByName(input.getName());
            this.logger.debug("<< reused securityGroup(%s)", new Object[]{group.getId()});
            return group;
        }
    }

    private void authorizeGroupToItselfAndToTCPPortAndCidr(CloudStackApi client, SecurityGroup securityGroup, int port, Set<String> cidrs) {
        for (String cidr : cidrs) {
            this.logger.debug(">> authorizing securityGroup(%s) permission to %s on port %d", new Object[]{securityGroup, cidr, port});
            if (SecurityGroupPredicates.portInRangeForCidr(port, cidr).apply((Object)securityGroup)) continue;
            this.jobComplete.apply((Object)client.getSecurityGroupApi().authorizeIngressPortsToCIDRs(securityGroup.getId(), "TCP", port, port, (Iterable<String>)ImmutableSet.of((Object)cidr), new AccountInDomainOptions[0]));
            this.logger.debug("<< authorized securityGroup(%s) permission to %s on port %d", new Object[]{securityGroup, cidr, port});
        }
    }
}

