/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.features.extension;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.resource.Requirement;

class BundleWires {
    long bundleId;
    Map<String, String> wiring = new HashMap<String, String>();

    BundleWires(Bundle bundle) {
        this.bundleId = bundle.getBundleId();
        for (BundleWire wire : ((BundleWiring)bundle.adapt(BundleWiring.class)).getRequiredWires(null)) {
            String requirementId = this.getRequirementId((Requirement)wire.getRequirement());
            String capabilityId = this.getCapabilityId(wire.getCapability());
            this.wiring.put(requirementId, capabilityId);
        }
    }

    BundleWires(long bundleId, BufferedReader reader) throws IOException {
        this.bundleId = bundleId;
        while (true) {
            String key = reader.readLine();
            String val = reader.readLine();
            if (key == null || val == null) break;
            this.wiring.put(key, val);
        }
    }

    void save(Path path) {
        try {
            Files.createDirectories(path, new FileAttribute[0]);
            Path file = path.resolve(Long.toString(this.bundleId));
            Files.createDirectories(file.getParent(), new FileAttribute[0]);
            try (BufferedWriter fw = Files.newBufferedWriter(file, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE, StandardOpenOption.CREATE);){
                for (Map.Entry<String, String> wire : this.wiring.entrySet()) {
                    fw.append(wire.getKey()).append('\n');
                    fw.append(wire.getValue()).append('\n');
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    void delete(Path path) {
        try {
            Files.createDirectories(path, new FileAttribute[0]);
            Path file = path.resolve(Long.toString(this.bundleId));
            Files.deleteIfExists(file);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    long getFragmentHost() {
        return this.wiring.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith("osgi.wiring.host")).map(Map.Entry::getValue).mapToLong(this::getBundleId).findFirst().orElse(-1L);
    }

    private long getBundleId(String value) {
        int idx = value.indexOf(59);
        if (idx > 0) {
            value = value.substring(0, idx);
        }
        return Long.parseLong(value.trim());
    }

    void filterMatches(BundleRequirement requirement, Collection<BundleCapability> candidates) {
        String cap = this.wiring.get(this.getRequirementId((Requirement)requirement));
        candidates.removeIf(cand -> this.checkRemove(cap, (BundleCapability)cand));
    }

    private boolean checkRemove(String cap, BundleCapability cand) {
        return cap != null && !cap.equals(this.getCapabilityId(cand)) || cap == null && cand.getRevision().getBundle().getBundleId() != this.bundleId;
    }

    private String getRequirementId(Requirement requirement) {
        String filter = (String)requirement.getDirectives().get("filter");
        if (filter != null) {
            return requirement.getNamespace() + "; " + filter;
        }
        return requirement.getNamespace();
    }

    private String getCapabilityId(BundleCapability capability) {
        StringBuilder sb = new StringBuilder(64);
        sb.append(capability.getRevision().getBundle().getBundleId());
        Object v = capability.getAttributes().get("version");
        if (v != null) {
            sb.append("; version=").append(v.toString());
        }
        return sb.toString();
    }
}

