/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.gogrid.compute.strategy;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Throwables;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.primitives.Longs;
import java.security.SecureRandom;
import java.util.Collection;
import java.util.Set;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.compute.ComputeServiceAdapter;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.reference.ComputeServiceConstants;
import org.jclouds.domain.Credentials;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.gogrid.GoGridApi;
import org.jclouds.gogrid.compute.suppliers.GoGridHardwareSupplier;
import org.jclouds.gogrid.domain.Ip;
import org.jclouds.gogrid.domain.IpType;
import org.jclouds.gogrid.domain.Option;
import org.jclouds.gogrid.domain.PowerCommand;
import org.jclouds.gogrid.domain.Server;
import org.jclouds.gogrid.domain.ServerImage;
import org.jclouds.gogrid.options.AddServerOptions;
import org.jclouds.gogrid.options.GetImageListOptions;
import org.jclouds.gogrid.options.GetIpListOptions;
import org.jclouds.gogrid.options.GetServerListOptions;
import org.jclouds.gogrid.predicates.ServerLatestJobCompleted;
import org.jclouds.logging.Logger;
import org.jclouds.util.Predicates2;

@Singleton
public class GoGridComputeServiceAdapter
implements ComputeServiceAdapter<Server, Hardware, ServerImage, Option> {
    @Resource
    protected Logger logger = Logger.NULL;
    private final GoGridApi client;
    private final Function<Hardware, String> sizeToRam;
    private final Predicate<Server> serverLatestJobCompleted;
    private final Predicate<Server> serverLatestJobCompletedShort;

    @Inject
    protected GoGridComputeServiceAdapter(GoGridApi client, Function<Hardware, String> sizeToRam, ComputeServiceConstants.Timeouts timeouts) {
        this.client = (GoGridApi)Preconditions.checkNotNull((Object)client, (Object)"client");
        this.sizeToRam = (Function)Preconditions.checkNotNull(sizeToRam, (Object)"sizeToRam");
        this.serverLatestJobCompleted = Predicates2.retry((Predicate)new ServerLatestJobCompleted(client.getJobServices()), (long)(timeouts.nodeRunning * 9L / 10L));
        this.serverLatestJobCompletedShort = Predicates2.retry((Predicate)new ServerLatestJobCompleted(client.getJobServices()), (long)(timeouts.nodeRunning * 1L / 10L));
    }

    public ComputeServiceAdapter.NodeAndInitialCredentials<Server> createNodeWithGroupEncodedIntoName(String group, String name, Template template) {
        Server addedServer = null;
        boolean notStarted = true;
        int numOfRetries = 20;
        GetIpListOptions unassignedIps = new GetIpListOptions().onlyUnassigned().inDatacenter(template.getLocation().getId()).onlyWithType(IpType.PUBLIC);
        while (notStarted) {
            Set<Ip> availableIps = this.client.getIpServices().getIpList(unassignedIps);
            if (availableIps.isEmpty()) {
                throw new RuntimeException("No IPs available on this identity.");
            }
            int ipIndex = new SecureRandom().nextInt(availableIps.size());
            Ip availableIp = (Ip)Iterables.get(availableIps, (int)ipIndex);
            try {
                addedServer = this.addServer(name, template, availableIp);
                notStarted = false;
            }
            catch (Exception e) {
                if (--numOfRetries == 0) {
                    Throwables.propagate((Throwable)e);
                }
                notStarted = true;
            }
        }
        if (template.getOptions().shouldBlockUntilRunning()) {
            this.serverLatestJobCompleted.apply(addedServer);
            this.client.getServerServices().power(addedServer.getName(), PowerCommand.START);
            this.serverLatestJobCompletedShort.apply((Object)addedServer);
            addedServer = (Server)Iterables.getOnlyElement(this.client.getServerServices().getServersByName(addedServer.getName()));
        }
        LoginCredentials credentials = LoginCredentials.fromCredentials((Credentials)this.client.getServerServices().getServerCredentialsList().get(addedServer.getName()));
        return new ComputeServiceAdapter.NodeAndInitialCredentials((Object)addedServer, addedServer.getId() + "", credentials);
    }

    private Server addServer(String name, Template template, Ip availableIp) {
        Server addedServer = this.client.getServerServices().addServer(name, (String)Preconditions.checkNotNull((Object)template.getImage().getProviderId()), (String)this.sizeToRam.apply((Object)template.getHardware()), availableIp.getIp(), new AddServerOptions[0]);
        return addedServer;
    }

    public Iterable<Hardware> listHardwareProfiles() {
        return GoGridHardwareSupplier.H_ALL;
    }

    public Iterable<ServerImage> listImages() {
        return this.client.getImageServices().getImageList(new GetImageListOptions[0]);
    }

    public Iterable<Server> listNodes() {
        return this.client.getServerServices().getServerList(new GetServerListOptions[0]);
    }

    public Iterable<Server> listNodesByIds(Iterable<String> ids) {
        ImmutableSet idsAsLongs = FluentIterable.from(ids).transform(this.toLong()).toSet();
        return this.client.getServerServices().getServersById(Longs.toArray((Collection)idsAsLongs));
    }

    public Iterable<Option> listLocations() {
        return this.client.getServerServices().getDatacenters();
    }

    public Server getNode(String id) {
        return (Server)Iterables.getOnlyElement(this.client.getServerServices().getServersById(Long.parseLong((String)Preconditions.checkNotNull((Object)id, (Object)"id"))), null);
    }

    public ServerImage getImage(String id) {
        return (ServerImage)Iterables.getOnlyElement(this.client.getImageServices().getImagesById(Long.parseLong((String)Preconditions.checkNotNull((Object)id, (Object)"id"))), null);
    }

    public void destroyNode(String id) {
        this.client.getServerServices().deleteById(Long.parseLong(id));
    }

    public void rebootNode(String id) {
        this.executeCommandOnServer(PowerCommand.RESTART, id);
        Server server = (Server)Iterables.getOnlyElement(this.client.getServerServices().getServersById(Long.parseLong(id)));
        this.client.getServerServices().power(server.getName(), PowerCommand.START);
        this.serverLatestJobCompletedShort.apply((Object)server);
    }

    private boolean executeCommandOnServer(PowerCommand command, String id) {
        Server server = (Server)Iterables.getOnlyElement(this.client.getServerServices().getServersById(Long.parseLong(id)));
        this.client.getServerServices().power(server.getName(), command);
        return this.serverLatestJobCompleted.apply((Object)server);
    }

    public void resumeNode(String id) {
        this.executeCommandOnServer(PowerCommand.START, id);
    }

    public void suspendNode(String id) {
        this.executeCommandOnServer(PowerCommand.STOP, id);
    }

    private Function<String, Long> toLong() {
        return new Function<String, Long>(){

            public Long apply(String id) {
                return Long.valueOf((String)Preconditions.checkNotNull((Object)id, (Object)"id"));
            }
        };
    }
}

