/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.messaging.kafka;

import org.apache.brooklyn.api.entity.ImplementedBy;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.annotation.Effector;
import org.apache.brooklyn.core.annotation.EffectorParam;
import org.apache.brooklyn.core.config.BasicConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.sensor.BasicAttributeSensorAndConfigKey;
import org.apache.brooklyn.entity.messaging.kafka.Kafka;
import org.apache.brooklyn.entity.messaging.kafka.KafkaZooKeeperImpl;
import org.apache.brooklyn.entity.software.base.SoftwareProcess;
import org.apache.brooklyn.entity.zookeeper.ZooKeeperNode;
import org.apache.brooklyn.util.core.flags.SetFromFlag;
import org.apache.brooklyn.util.time.Duration;

@ImplementedBy(value=KafkaZooKeeperImpl.class)
public interface KafkaZooKeeper
extends ZooKeeperNode,
Kafka {
    @SetFromFlag(value="startTimeout")
    public static final ConfigKey<Duration> START_TIMEOUT = SoftwareProcess.START_TIMEOUT;
    @SetFromFlag(value="version")
    public static final ConfigKey<String> SUGGESTED_VERSION = Kafka.SUGGESTED_VERSION;
    @SetFromFlag(value="downloadUrl")
    public static final BasicAttributeSensorAndConfigKey<String> DOWNLOAD_URL = Kafka.DOWNLOAD_URL;
    @SetFromFlag(value="kafkaZookeeperConfig")
    public static final ConfigKey<String> KAFKA_ZOOKEEPER_CONFIG_TEMPLATE = new BasicConfigKey(String.class, "kafka.zookeeper.configTemplate", "Kafka zookeeper configuration template (in freemarker format)", (Object)"classpath://org/apache/brooklyn/entity/messaging/kafka/zookeeper.properties");
    @SetFromFlag(value="archiveNameFormat")
    public static final ConfigKey<String> ARCHIVE_DIRECTORY_NAME_FORMAT = ConfigKeys.newConfigKeyWithDefault((ConfigKey)SoftwareProcess.ARCHIVE_DIRECTORY_NAME_FORMAT, (Object)"kafka_%s");

    @Effector(description="Create a topic with a single partition and only one replica")
    public void createTopic(@EffectorParam(name="topic") String var1);
}

