/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.hadoop.util;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.HadoopReadOptions;
import org.apache.parquet.bytes.BytesInput;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.page.DictionaryPage;
import org.apache.parquet.column.page.PageReadStore;
import org.apache.parquet.crypto.AesCipher;
import org.apache.parquet.crypto.FileEncryptionProperties;
import org.apache.parquet.crypto.InternalColumnEncryptionSetup;
import org.apache.parquet.crypto.InternalFileEncryptor;
import org.apache.parquet.crypto.ModuleCipherFactory;
import org.apache.parquet.format.BlockCipher;
import org.apache.parquet.format.DataPageHeader;
import org.apache.parquet.format.DataPageHeaderV2;
import org.apache.parquet.format.DictionaryPageHeader;
import org.apache.parquet.format.PageHeader;
import org.apache.parquet.format.converter.ParquetMetadataConverter;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.ParquetFileWriter;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.hadoop.metadata.ColumnPath;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.hadoop.util.CompressionConverter;
import org.apache.parquet.hadoop.util.HadoopInputFile;
import org.apache.parquet.hadoop.util.HadoopOutputFile;
import org.apache.parquet.internal.column.columnindex.OffsetIndex;
import org.apache.parquet.io.OutputFile;
import org.apache.parquet.schema.MessageType;

public class ColumnEncryptor {
    private Configuration conf;

    public ColumnEncryptor(Configuration conf) {
        this.conf = conf;
    }

    public void encryptColumns(String inputFile, String outputFile, List<String> paths, FileEncryptionProperties fileEncryptionProperties) throws IOException {
        Path inPath = new Path(inputFile);
        Path outPath = new Path(outputFile);
        ParquetMetadata metaData = ParquetFileReader.readFooter(this.conf, inPath, ParquetMetadataConverter.NO_FILTER);
        MessageType schema = metaData.getFileMetaData().getSchema();
        ParquetFileWriter writer = new ParquetFileWriter((OutputFile)HadoopOutputFile.fromPath(outPath, this.conf), schema, ParquetFileWriter.Mode.OVERWRITE, 0x8000000L, 0x800000, 64, Integer.MAX_VALUE, true, fileEncryptionProperties);
        writer.start();
        try (CompressionConverter.TransParquetFileReader reader = new CompressionConverter.TransParquetFileReader(HadoopInputFile.fromPath(inPath, this.conf), HadoopReadOptions.builder(this.conf).build());){
            this.processBlocks(reader, writer, metaData, schema, paths);
        }
        writer.end(metaData.getFileMetaData().getKeyValueMetaData());
    }

    private void processBlocks(CompressionConverter.TransParquetFileReader reader, ParquetFileWriter writer, ParquetMetadata meta, MessageType schema, List<String> encryptPaths) throws IOException {
        Set<ColumnPath> encryptColumnsPath = ColumnEncryptor.convertToColumnPaths(encryptPaths);
        int blockId = 0;
        PageReadStore store = reader.readNextRowGroup();
        while (store != null) {
            writer.startBlock(store.getRowCount());
            List<ColumnChunkMetaData> columnsInOrder = meta.getBlocks().get(blockId).getColumns();
            Map<ColumnPath, ColumnDescriptor> descriptorsMap = schema.getColumns().stream().collect(Collectors.toMap(x -> ColumnPath.get((String[])x.getPath()), x -> x));
            for (int i = 0; i < columnsInOrder.size(); ++i) {
                ColumnChunkMetaData chunk = columnsInOrder.get(i);
                if (chunk.isEncrypted()) {
                    throw new IOException("Column " + chunk.getPath().toDotString() + " is already encrypted");
                }
                ColumnDescriptor descriptor = descriptorsMap.get(chunk.getPath());
                this.processChunk(descriptor, chunk, reader, writer, encryptColumnsPath, blockId, i, meta.getFileMetaData().getCreatedBy());
            }
            writer.endBlock();
            store = reader.readNextRowGroup();
            ++blockId;
        }
    }

    private void processChunk(ColumnDescriptor descriptor, ColumnChunkMetaData chunk, CompressionConverter.TransParquetFileReader reader, ParquetFileWriter writer, Set<ColumnPath> encryptPaths, int blockId, int columnId, String createdBy) throws IOException {
        reader.setStreamPosition(chunk.getStartingPos());
        writer.startColumn(descriptor, chunk.getValueCount(), chunk.getCodec());
        this.processPages(reader, chunk, writer, createdBy, blockId, columnId, encryptPaths.contains(chunk.getPath()));
        writer.endColumn();
    }

    private void processPages(CompressionConverter.TransParquetFileReader reader, ColumnChunkMetaData chunk, ParquetFileWriter writer, String createdBy, int blockId, int columnId, boolean encrypt) throws IOException {
        int pageOrdinal = 0;
        EncryptorRunTime encryptorRunTime = new EncryptorRunTime(writer.getEncryptor(), chunk, blockId, columnId);
        Object dictionaryPage = null;
        long readValues = 0L;
        ParquetMetadataConverter converter = new ParquetMetadataConverter();
        OffsetIndex offsetIndex = reader.readOffsetIndex(chunk);
        reader.setStreamPosition(chunk.getStartingPos());
        long totalChunkValues = chunk.getValueCount();
        while (readValues < totalChunkValues) {
            PageHeader pageHeader = reader.readPageHeader();
            switch (pageHeader.type) {
                case DICTIONARY_PAGE: {
                    if (dictionaryPage != null) {
                        throw new IOException("has more than one dictionary page in column chunk");
                    }
                    DictionaryPageHeader dictPageHeader = pageHeader.dictionary_page_header;
                    byte[] pageLoad = this.processPayload(reader, pageHeader.getCompressed_page_size(), encryptorRunTime.getDataEncryptor(), encryptorRunTime.getDictPageAAD(), encrypt);
                    writer.writeDictionaryPage(new DictionaryPage(BytesInput.from((byte[])pageLoad), pageHeader.getUncompressed_page_size(), dictPageHeader.getNum_values(), converter.getEncoding(dictPageHeader.getEncoding())), encryptorRunTime.getMetaDataEncryptor(), encryptorRunTime.getDictPageHeaderAAD());
                    break;
                }
                case DATA_PAGE: {
                    if (encrypt) {
                        AesCipher.quickUpdatePageAAD(encryptorRunTime.getDataPageHeaderAAD(), pageOrdinal);
                        AesCipher.quickUpdatePageAAD(encryptorRunTime.getDataPageAAD(), pageOrdinal);
                    }
                    DataPageHeader headerV1 = pageHeader.data_page_header;
                    byte[] pageLoad = this.processPayload(reader, pageHeader.getCompressed_page_size(), encryptorRunTime.getDataEncryptor(), encryptorRunTime.getDataPageAAD(), encrypt);
                    readValues += (long)headerV1.getNum_values();
                    if (offsetIndex != null) {
                        long rowCount = 1L + offsetIndex.getLastRowIndex(pageOrdinal, totalChunkValues) - offsetIndex.getFirstRowIndex(pageOrdinal);
                        writer.writeDataPage(Math.toIntExact(headerV1.getNum_values()), pageHeader.getUncompressed_page_size(), BytesInput.from((byte[])pageLoad), converter.fromParquetStatistics(createdBy, headerV1.getStatistics(), chunk.getPrimitiveType()), rowCount, converter.getEncoding(headerV1.getRepetition_level_encoding()), converter.getEncoding(headerV1.getDefinition_level_encoding()), converter.getEncoding(headerV1.getEncoding()), encryptorRunTime.getMetaDataEncryptor(), encryptorRunTime.getDataPageHeaderAAD());
                    } else {
                        writer.writeDataPage(Math.toIntExact(headerV1.getNum_values()), pageHeader.getUncompressed_page_size(), BytesInput.from((byte[])pageLoad), converter.fromParquetStatistics(createdBy, headerV1.getStatistics(), chunk.getPrimitiveType()), converter.getEncoding(headerV1.getRepetition_level_encoding()), converter.getEncoding(headerV1.getDefinition_level_encoding()), converter.getEncoding(headerV1.getEncoding()), encryptorRunTime.getMetaDataEncryptor(), encryptorRunTime.getDataPageHeaderAAD());
                    }
                    ++pageOrdinal;
                    break;
                }
                case DATA_PAGE_V2: {
                    if (encrypt) {
                        AesCipher.quickUpdatePageAAD(encryptorRunTime.getDataPageHeaderAAD(), pageOrdinal);
                        AesCipher.quickUpdatePageAAD(encryptorRunTime.getDataPageAAD(), pageOrdinal);
                    }
                    DataPageHeaderV2 headerV2 = pageHeader.data_page_header_v2;
                    int rlLength = headerV2.getRepetition_levels_byte_length();
                    BytesInput rlLevels = this.readBlockAllocate(rlLength, reader);
                    int dlLength = headerV2.getDefinition_levels_byte_length();
                    BytesInput dlLevels = this.readBlockAllocate(dlLength, reader);
                    int payLoadLength = pageHeader.getCompressed_page_size() - rlLength - dlLength;
                    int rawDataLength = pageHeader.getUncompressed_page_size() - rlLength - dlLength;
                    byte[] pageLoad = this.processPayload(reader, payLoadLength, encryptorRunTime.getDataEncryptor(), encryptorRunTime.getDataPageAAD(), encrypt);
                    readValues += (long)headerV2.getNum_values();
                    writer.writeDataPageV2(headerV2.getNum_rows(), headerV2.getNum_nulls(), headerV2.getNum_values(), rlLevels, dlLevels, converter.getEncoding(headerV2.getEncoding()), BytesInput.from((byte[])pageLoad), rawDataLength, converter.fromParquetStatistics(createdBy, headerV2.getStatistics(), chunk.getPrimitiveType()));
                    ++pageOrdinal;
                    break;
                }
            }
        }
    }

    private byte[] processPayload(CompressionConverter.TransParquetFileReader reader, int payloadLength, BlockCipher.Encryptor dataEncryptor, byte[] AAD, boolean encrypt) throws IOException {
        byte[] data = this.readBlock(payloadLength, reader);
        if (!encrypt) {
            return data;
        }
        return dataEncryptor.encrypt(data, AAD);
    }

    public byte[] readBlock(int length, CompressionConverter.TransParquetFileReader reader) throws IOException {
        byte[] data = new byte[length];
        reader.blockRead(data, 0, length);
        return data;
    }

    public BytesInput readBlockAllocate(int length, CompressionConverter.TransParquetFileReader reader) throws IOException {
        byte[] data = new byte[length];
        reader.blockRead(data, 0, length);
        return BytesInput.from((byte[])data, (int)0, (int)length);
    }

    public static Set<ColumnPath> convertToColumnPaths(List<String> cols) {
        HashSet<ColumnPath> prunePaths = new HashSet<ColumnPath>();
        for (String col : cols) {
            prunePaths.add(ColumnPath.fromDotString((String)col));
        }
        return prunePaths;
    }

    private static class EncryptorRunTime {
        private final InternalColumnEncryptionSetup colEncrSetup;
        private final BlockCipher.Encryptor dataEncryptor;
        private final BlockCipher.Encryptor metaDataEncryptor;
        private final byte[] fileAAD;
        private byte[] dataPageHeaderAAD;
        private byte[] dataPageAAD;
        private byte[] dictPageHeaderAAD;
        private byte[] dictPageAAD;

        public EncryptorRunTime(InternalFileEncryptor fileEncryptor, ColumnChunkMetaData chunk, int blockId, int columnId) throws IOException {
            if (fileEncryptor == null) {
                this.colEncrSetup = null;
                this.dataEncryptor = null;
                this.metaDataEncryptor = null;
                this.fileAAD = null;
                this.dataPageHeaderAAD = null;
                this.dataPageAAD = null;
                this.dictPageHeaderAAD = null;
                this.dictPageAAD = null;
            } else {
                this.colEncrSetup = fileEncryptor.getColumnSetup(chunk.getPath(), true, columnId);
                this.dataEncryptor = this.colEncrSetup.getDataEncryptor();
                this.metaDataEncryptor = this.colEncrSetup.getMetaDataEncryptor();
                this.fileAAD = fileEncryptor.getFileAAD();
                this.dataPageHeaderAAD = this.createAAD(this.colEncrSetup, ModuleCipherFactory.ModuleType.DataPageHeader, blockId, columnId);
                this.dataPageAAD = this.createAAD(this.colEncrSetup, ModuleCipherFactory.ModuleType.DataPage, blockId, columnId);
                this.dictPageHeaderAAD = this.createAAD(this.colEncrSetup, ModuleCipherFactory.ModuleType.DictionaryPageHeader, blockId, columnId);
                this.dictPageAAD = this.createAAD(this.colEncrSetup, ModuleCipherFactory.ModuleType.DictionaryPage, blockId, columnId);
            }
        }

        private byte[] createAAD(InternalColumnEncryptionSetup colEncrSetup, ModuleCipherFactory.ModuleType moduleType, int blockId, int columnId) {
            if (colEncrSetup != null && colEncrSetup.isEncrypted()) {
                return AesCipher.createModuleAAD(this.fileAAD, moduleType, blockId, columnId, 0);
            }
            return null;
        }

        public BlockCipher.Encryptor getDataEncryptor() {
            return this.dataEncryptor;
        }

        public BlockCipher.Encryptor getMetaDataEncryptor() {
            return this.metaDataEncryptor;
        }

        public byte[] getDataPageHeaderAAD() {
            return this.dataPageHeaderAAD;
        }

        public byte[] getDataPageAAD() {
            return this.dataPageAAD;
        }

        public byte[] getDictPageHeaderAAD() {
            return this.dictPageHeaderAAD;
        }

        public byte[] getDictPageAAD() {
            return this.dictPageAAD;
        }
    }
}

