/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.core.algebra.properties;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hyracks.algebricks.common.utils.ListSet;
import org.apache.hyracks.algebricks.core.algebra.base.EquivalenceClass;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.properties.AbstractGroupingProperty;
import org.apache.hyracks.algebricks.core.algebra.properties.FunctionalDependency;
import org.apache.hyracks.algebricks.core.algebra.properties.INodeDomain;
import org.apache.hyracks.algebricks.core.algebra.properties.IPartitioningProperty;

public final class UnorderedPartitionedProperty
extends AbstractGroupingProperty
implements IPartitioningProperty {
    private INodeDomain domain;
    private final int[][] partitionsMap;

    private UnorderedPartitionedProperty(Set<LogicalVariable> partitioningVariables, INodeDomain domain, int[][] partitionsMap) {
        super(partitioningVariables);
        this.domain = domain;
        this.partitionsMap = partitionsMap;
    }

    public static UnorderedPartitionedProperty of(Set<LogicalVariable> partitioningVariables, INodeDomain domain) {
        return new UnorderedPartitionedProperty(partitioningVariables, domain, null);
    }

    public static UnorderedPartitionedProperty ofPartitionsMap(Set<LogicalVariable> partitioningVariables, INodeDomain domain, int[][] partitionsMap) {
        return new UnorderedPartitionedProperty(partitioningVariables, domain, partitionsMap);
    }

    @Override
    public IPartitioningProperty.PartitioningType getPartitioningType() {
        return IPartitioningProperty.PartitioningType.UNORDERED_PARTITIONED;
    }

    @Override
    public IPartitioningProperty normalize(Map<LogicalVariable, EquivalenceClass> equivalenceClasses, List<FunctionalDependency> fds) {
        Set<LogicalVariable> normalizedColumnSet = this.normalizeAndReduceGroupingColumns(this.columnSet, equivalenceClasses, fds);
        return new UnorderedPartitionedProperty(normalizedColumnSet, this.domain, this.partitionsMap);
    }

    public String toString() {
        return this.getPartitioningType().toString() + this.columnSet + " domain:" + this.domain;
    }

    @Override
    public void getColumns(Collection<LogicalVariable> columns) {
        columns.addAll(this.columnSet);
    }

    @Override
    public INodeDomain getNodeDomain() {
        return this.domain;
    }

    @Override
    public void setNodeDomain(INodeDomain domain) {
        this.domain = domain;
    }

    @Override
    public IPartitioningProperty substituteColumnVars(Map<LogicalVariable, LogicalVariable> varMap) {
        boolean applied = false;
        ListSet newColumnSet = new ListSet();
        for (LogicalVariable variable : this.columnSet) {
            if (varMap.containsKey(variable)) {
                newColumnSet.add(varMap.get(variable));
                applied = true;
                continue;
            }
            newColumnSet.add(variable);
        }
        return applied ? new UnorderedPartitionedProperty((Set<LogicalVariable>)newColumnSet, this.domain, this.partitionsMap) : this;
    }

    @Override
    public IPartitioningProperty clonePartitioningProperty() {
        return new UnorderedPartitionedProperty((Set<LogicalVariable>)new ListSet((Collection)this.columnSet), this.domain, this.partitionsMap);
    }

    public int[][] getPartitionsMap() {
        return this.partitionsMap;
    }

    public boolean usesPartitionsMap() {
        return this.partitionsMap != null;
    }

    public boolean samePartitioningScheme(UnorderedPartitionedProperty another) {
        return Arrays.deepEquals((Object[])this.partitionsMap, (Object[])another.partitionsMap);
    }
}

