/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.cloud.lazy.accessor;

import java.io.FilenameFilter;
import java.util.Set;
import org.apache.asterix.cloud.CloudFileHandle;
import org.apache.asterix.cloud.bulk.IBulkOperationCallBack;
import org.apache.asterix.cloud.bulk.NoOpDeleteBulkCallBack;
import org.apache.asterix.cloud.clients.ICloudClient;
import org.apache.asterix.cloud.lazy.accessor.AbstractLazyAccessor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.io.IIOManager;
import org.apache.hyracks.control.nc.io.IOManager;

public class LocalAccessor
extends AbstractLazyAccessor {
    public LocalAccessor(ICloudClient cloudClient, String bucket, IOManager localIoManager) {
        super(cloudClient, bucket, localIoManager);
    }

    @Override
    public boolean isLocalAccessor() {
        return true;
    }

    @Override
    public IBulkOperationCallBack getBulkOperationCallBack() {
        return NoOpDeleteBulkCallBack.INSTANCE;
    }

    @Override
    public void doOnOpen(CloudFileHandle fileHandle, IIOManager.FileReadWriteMode rwMode, IIOManager.FileSyncMode syncMode) throws HyracksDataException {
    }

    @Override
    public Set<FileReference> doList(FileReference dir, FilenameFilter filter) throws HyracksDataException {
        return this.localIoManager.list(dir, filter);
    }

    @Override
    public boolean doExists(FileReference fileRef) throws HyracksDataException {
        return this.localIoManager.exists(fileRef);
    }

    @Override
    public long doGetSize(FileReference fileReference) throws HyracksDataException {
        return this.localIoManager.getSize(fileReference);
    }

    @Override
    public byte[] doReadAllBytes(FileReference fileReference) throws HyracksDataException {
        return this.localIoManager.readAllBytes(fileReference);
    }

    @Override
    public void doDelete(FileReference fileReference) throws HyracksDataException {
        this.doCloudDelete(fileReference);
        this.localIoManager.delete(fileReference);
    }

    @Override
    public void doOverwrite(FileReference fileReference, byte[] bytes) throws HyracksDataException {
        this.cloudClient.write(this.bucket, fileReference.getRelativePath(), bytes);
        this.localIoManager.overwrite(fileReference, bytes);
    }
}

