/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.internal.multipart;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.async.AsyncRequestBody;
import software.amazon.awssdk.services.s3.model.CompletedPart;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.utils.Pair;

@SdkInternalApi
public class MpuRequestContext {
    private final Pair<PutObjectRequest, AsyncRequestBody> request;
    private final Long contentLength;
    private final Long partSize;
    private final Long numPartsCompleted;
    private final String uploadId;
    private final Map<Integer, CompletedPart> existingParts;

    protected MpuRequestContext(Builder builder) {
        this.request = builder.request;
        this.contentLength = builder.contentLength;
        this.partSize = builder.partSize;
        this.uploadId = builder.uploadId;
        this.existingParts = builder.existingParts;
        this.numPartsCompleted = builder.numPartsCompleted;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MpuRequestContext that = (MpuRequestContext)o;
        return Objects.equals(this.request, that.request) && Objects.equals(this.contentLength, that.contentLength) && Objects.equals(this.partSize, that.partSize) && Objects.equals(this.numPartsCompleted, that.numPartsCompleted) && Objects.equals(this.uploadId, that.uploadId) && Objects.equals(this.existingParts, that.existingParts);
    }

    public int hashCode() {
        int result = this.request != null ? this.request.hashCode() : 0;
        result = 31 * result + (this.uploadId != null ? this.uploadId.hashCode() : 0);
        result = 31 * result + (this.existingParts != null ? this.existingParts.hashCode() : 0);
        result = 31 * result + (this.contentLength != null ? this.contentLength.hashCode() : 0);
        result = 31 * result + (this.partSize != null ? this.partSize.hashCode() : 0);
        result = 31 * result + (this.numPartsCompleted != null ? this.numPartsCompleted.hashCode() : 0);
        return result;
    }

    public Pair<PutObjectRequest, AsyncRequestBody> request() {
        return this.request;
    }

    public Long contentLength() {
        return this.contentLength;
    }

    public Long partSize() {
        return this.partSize;
    }

    public Long numPartsCompleted() {
        return this.numPartsCompleted;
    }

    public String uploadId() {
        return this.uploadId;
    }

    public Map<Integer, CompletedPart> existingParts() {
        return this.existingParts != null ? Collections.unmodifiableMap(this.existingParts) : null;
    }

    public static final class Builder {
        private Pair<PutObjectRequest, AsyncRequestBody> request;
        private Long contentLength;
        private Long partSize;
        private Long numPartsCompleted;
        private String uploadId;
        private Map<Integer, CompletedPart> existingParts;

        private Builder() {
        }

        public Builder request(Pair<PutObjectRequest, AsyncRequestBody> request) {
            this.request = request;
            return this;
        }

        public Builder contentLength(Long contentLength) {
            this.contentLength = contentLength;
            return this;
        }

        public Builder partSize(Long partSize) {
            this.partSize = partSize;
            return this;
        }

        public Builder numPartsCompleted(Long numPartsCompleted) {
            this.numPartsCompleted = numPartsCompleted;
            return this;
        }

        public Builder uploadId(String uploadId) {
            this.uploadId = uploadId;
            return this;
        }

        public Builder existingParts(Map<Integer, CompletedPart> existingParts) {
            this.existingParts = existingParts;
            return this;
        }

        public MpuRequestContext build() {
            return new MpuRequestContext(this);
        }
    }
}

