/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.parquet;

import org.apache.iceberg.Schema;
import org.apache.iceberg.avro.AvroSchemaUtil;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;

public class TypeToMessageType {
    public static final int DECIMAL_INT32_MAX_DIGITS = 9;
    public static final int DECIMAL_INT64_MAX_DIGITS = 18;
    private static final LogicalTypeAnnotation STRING = LogicalTypeAnnotation.stringType();
    private static final LogicalTypeAnnotation DATE = LogicalTypeAnnotation.dateType();
    private static final LogicalTypeAnnotation TIME_MICROS = LogicalTypeAnnotation.timeType((boolean)false, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MICROS);
    private static final LogicalTypeAnnotation TIMESTAMP_MICROS = LogicalTypeAnnotation.timestampType((boolean)false, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MICROS);
    private static final LogicalTypeAnnotation TIMESTAMPTZ_MICROS = LogicalTypeAnnotation.timestampType((boolean)true, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MICROS);

    public MessageType convert(Schema schema, String name) {
        Types.MessageTypeBuilder builder = Types.buildMessage();
        for (Types.NestedField field : schema.columns()) {
            builder.addField(this.field(field));
        }
        return builder.named(AvroSchemaUtil.makeCompatibleName((String)name));
    }

    public GroupType struct(Types.StructType struct, Type.Repetition repetition, int id, String name) {
        Types.GroupBuilder builder = Types.buildGroup((Type.Repetition)repetition);
        for (Types.NestedField field : struct.fields()) {
            builder.addField(this.field(field));
        }
        return (GroupType)((Types.GroupBuilder)builder.id(id)).named(AvroSchemaUtil.makeCompatibleName((String)name));
    }

    public Type field(Types.NestedField field) {
        Type.Repetition repetition = field.isOptional() ? Type.Repetition.OPTIONAL : Type.Repetition.REQUIRED;
        int id = field.fieldId();
        String name = field.name();
        if (field.type().isPrimitiveType()) {
            return this.primitive(field.type().asPrimitiveType(), repetition, id, name);
        }
        Type.NestedType nested = field.type().asNestedType();
        if (nested.isStructType()) {
            return this.struct(nested.asStructType(), repetition, id, name);
        }
        if (nested.isMapType()) {
            return this.map(nested.asMapType(), repetition, id, name);
        }
        if (nested.isListType()) {
            return this.list(nested.asListType(), repetition, id, name);
        }
        throw new UnsupportedOperationException("Can't convert unknown type: " + nested);
    }

    public GroupType list(Types.ListType list, Type.Repetition repetition, int id, String name) {
        Types.NestedField elementField = (Types.NestedField)list.fields().get(0);
        return (GroupType)((Types.ListBuilder)Types.list((Type.Repetition)repetition).element(this.field(elementField)).id(id)).named(AvroSchemaUtil.makeCompatibleName((String)name));
    }

    public GroupType map(Types.MapType map, Type.Repetition repetition, int id, String name) {
        Types.NestedField keyField = (Types.NestedField)map.fields().get(0);
        Types.NestedField valueField = (Types.NestedField)map.fields().get(1);
        return (GroupType)((Types.MapBuilder)((Types.MapBuilder)((Types.MapBuilder)Types.map((Type.Repetition)repetition).key(this.field(keyField))).value(this.field(valueField))).id(id)).named(AvroSchemaUtil.makeCompatibleName((String)name));
    }

    public Type primitive(Type.PrimitiveType primitive, Type.Repetition repetition, int id, String originalName) {
        String name = AvroSchemaUtil.makeCompatibleName((String)originalName);
        switch (primitive.typeId()) {
            case BOOLEAN: {
                return (Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BOOLEAN, (Type.Repetition)repetition).id(id)).named(name);
            }
            case INTEGER: {
                return (Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)repetition).id(id)).named(name);
            }
            case LONG: {
                return (Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)repetition).id(id)).named(name);
            }
            case FLOAT: {
                return (Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FLOAT, (Type.Repetition)repetition).id(id)).named(name);
            }
            case DOUBLE: {
                return (Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.DOUBLE, (Type.Repetition)repetition).id(id)).named(name);
            }
            case DATE: {
                return (Type)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)repetition).as(DATE)).id(id)).named(name);
            }
            case TIME: {
                return (Type)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)repetition).as(TIME_MICROS)).id(id)).named(name);
            }
            case TIMESTAMP: {
                if (((Types.TimestampType)primitive).shouldAdjustToUTC()) {
                    return (Type)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)repetition).as(TIMESTAMPTZ_MICROS)).id(id)).named(name);
                }
                return (Type)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)repetition).as(TIMESTAMP_MICROS)).id(id)).named(name);
            }
            case STRING: {
                return (Type)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (Type.Repetition)repetition).as(STRING)).id(id)).named(name);
            }
            case BINARY: {
                return (Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (Type.Repetition)repetition).id(id)).named(name);
            }
            case FIXED: {
                Types.FixedType fixed = (Types.FixedType)primitive;
                return (Type)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY, (Type.Repetition)repetition).length(fixed.length())).id(id)).named(name);
            }
            case DECIMAL: {
                Types.DecimalType decimal = (Types.DecimalType)primitive;
                if (decimal.precision() <= 9) {
                    return (Type)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)repetition).as(TypeToMessageType.decimalAnnotation(decimal.precision(), decimal.scale()))).id(id)).named(name);
                }
                if (decimal.precision() <= 18) {
                    return (Type)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)repetition).as(TypeToMessageType.decimalAnnotation(decimal.precision(), decimal.scale()))).id(id)).named(name);
                }
                int minLength = TypeUtil.decimalRequiredBytes((int)decimal.precision());
                return (Type)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY, (Type.Repetition)repetition).length(minLength)).as(TypeToMessageType.decimalAnnotation(decimal.precision(), decimal.scale()))).id(id)).named(name);
            }
            case UUID: {
                return (Type)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY, (Type.Repetition)repetition).length(16)).as((LogicalTypeAnnotation)LogicalTypeAnnotation.uuidType())).id(id)).named(name);
            }
        }
        throw new UnsupportedOperationException("Unsupported type for Parquet: " + primitive);
    }

    private static LogicalTypeAnnotation decimalAnnotation(int precision, int scale) {
        return LogicalTypeAnnotation.decimalType((int)scale, (int)precision);
    }
}

