/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.input.stream;

import java.io.IOException;
import org.apache.asterix.external.api.AsterixInputStream;
import org.apache.asterix.external.input.stream.AbstractMultipleInputStream;

public class DiscretizedMultipleInputStream
extends AsterixInputStream {
    private final IStreamWrapper stream;

    public DiscretizedMultipleInputStream(AsterixInputStream inputStream) {
        if (inputStream instanceof AbstractMultipleInputStream) {
            AbstractMultipleInputStream multipleInputStream = (AbstractMultipleInputStream)inputStream;
            this.stream = new MultipleStreamWrapper(multipleInputStream);
        } else {
            this.stream = new SingleStreamWrapper(inputStream);
        }
    }

    @Override
    public int read() throws IOException {
        return this.stream.read();
    }

    public boolean advance() throws IOException {
        return this.stream.advance();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.stream.read(b, off, len);
    }

    @Override
    public boolean stop() throws Exception {
        return this.stream.getInputStream().stop();
    }

    @Override
    public boolean handleException(Throwable th) {
        return this.stream.getInputStream().handleException(th);
    }

    private static class MultipleStreamWrapper
    implements IStreamWrapper {
        private final AbstractMultipleInputStream inputStream;

        private MultipleStreamWrapper(AbstractMultipleInputStream inputStream) {
            this.inputStream = inputStream;
        }

        @Override
        public boolean advance() throws IOException {
            return this.inputStream.advance();
        }

        @Override
        public int read() throws IOException {
            return this.inputStream.in.read();
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this.inputStream.in.read(b, off, len);
        }

        @Override
        public AsterixInputStream getInputStream() {
            return this.inputStream;
        }
    }

    private static interface IStreamWrapper {
        public boolean advance() throws IOException;

        public int read() throws IOException;

        public int read(byte[] var1, int var2, int var3) throws IOException;

        public AsterixInputStream getInputStream();
    }

    private static class SingleStreamWrapper
    implements IStreamWrapper {
        private final AsterixInputStream inputStream;

        private SingleStreamWrapper(AsterixInputStream inputStream) {
            this.inputStream = inputStream;
        }

        @Override
        public boolean advance() {
            return false;
        }

        @Override
        public int read() throws IOException {
            return this.inputStream.read();
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this.inputStream.read(b, off, len);
        }

        @Override
        public AsterixInputStream getInputStream() {
            return this.inputStream;
        }
    }
}

