/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.data.utils;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.hyracks.util.string.UTF8StringUtil;

public final class WriteValueTools {
    private static final int[] INT_INTERVALS = new int[]{9, 99, 999, 9999, 99999, 999999, 9999999, 99999999, 999999999, Integer.MAX_VALUE};
    private static final int[] INT_DIVIDERS = new int[]{10, 100, 1000, 10000, 100000, 1000000, 10000000, 100000000, 1000000000};
    private static final int[] DIGITS = new int[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57};

    public static void writeInt(int i, OutputStream os) throws IOException {
        int k;
        if (i < 0) {
            if (i == Integer.MIN_VALUE) {
                os.write("-2147483648".getBytes());
                return;
            }
            os.write(45);
            i = -i;
        }
        for (k = 0; k < INT_INTERVALS.length && i > INT_INTERVALS[k]; ++k) {
        }
        while (k > 0) {
            int q = i / INT_DIVIDERS[k - 1];
            os.write(DIGITS[q % 10]);
            --k;
        }
        os.write(DIGITS[i % 10]);
    }

    public static void writeLong(long d, OutputStream os) throws IOException {
        long divisor;
        if (d < 0L) {
            if (d == Long.MIN_VALUE) {
                os.write("-9223372036854775808".getBytes());
                return;
            }
            os.write(45);
            d = -d;
        }
        for (divisor = 1000000000000000000L; divisor > d; divisor /= 10L) {
        }
        while (divisor > 1L) {
            os.write(DIGITS[(int)(d / divisor % 10L)]);
            divisor /= 10L;
        }
        os.write(DIGITS[(int)(d % 10L)]);
    }

    public static void writeUTF8StringWithQuotes(String string, OutputStream ps) throws IOException {
        UTF8StringUtil.printUTF8StringWithQuotes((String)string, (OutputStream)ps);
    }

    public static void writeUTF8StringNoQuotes(String string, OutputStream ps) throws IOException {
        UTF8StringUtil.printUTF8StringNoQuotes((String)string, (OutputStream)ps);
    }
}

