/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.input.record.reader.hdfs;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.StandardCharsets;
import org.apache.asterix.external.api.IRawRecord;
import org.apache.asterix.external.indexing.ExternalFileIndexAccessor;
import org.apache.asterix.external.indexing.RecordId;
import org.apache.asterix.external.input.record.CharArrayRecord;
import org.apache.asterix.external.input.record.reader.hdfs.AbstractHDFSLookupRecordReader;
import org.apache.asterix.external.util.ExternalDataConstants;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.io.Text;

public abstract class AbstractCharRecordLookupReader
extends AbstractHDFSLookupRecordReader<char[]> {
    protected CharArrayRecord record = new CharArrayRecord();
    protected Text value = new Text();
    protected CharsetDecoder decoder = StandardCharsets.UTF_8.newDecoder();
    protected ByteBuffer reusableByteBuffer = ByteBuffer.allocateDirect(ExternalDataConstants.DEFAULT_BUFFER_SIZE);
    protected CharBuffer reusableCharBuffer = CharBuffer.allocate(ExternalDataConstants.DEFAULT_BUFFER_SIZE);

    public AbstractCharRecordLookupReader(ExternalFileIndexAccessor snapshotAccessor, FileSystem fs, Configuration conf) {
        super(snapshotAccessor, fs, conf);
    }

    @Override
    public Class<?> getRecordClass() throws IOException {
        return char[].class;
    }

    @Override
    protected IRawRecord<char[]> lookup(RecordId rid) throws IOException {
        this.record.reset();
        this.readRecord(rid);
        this.writeRecord();
        return this.record;
    }

    protected abstract void readRecord(RecordId var1) throws IOException;

    private void writeRecord() throws IOException {
        this.reusableByteBuffer.clear();
        if (this.reusableByteBuffer.remaining() < this.value.getLength()) {
            this.reusableByteBuffer = ByteBuffer.allocateDirect((int)((float)this.value.getLength() * 1.5f));
        }
        this.reusableByteBuffer.put(this.value.getBytes(), 0, this.value.getLength());
        this.reusableByteBuffer.flip();
        while (this.reusableByteBuffer.hasRemaining()) {
            this.reusableCharBuffer.clear();
            this.decoder.decode(this.reusableByteBuffer, this.reusableCharBuffer, false);
            this.reusableCharBuffer.flip();
            this.record.append(this.reusableCharBuffer);
        }
        this.record.endRecord();
    }
}

