/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.invertedindex.tokenizers;

import org.apache.hyracks.storage.am.lsm.invertedindex.tokenizers.IBinaryTokenizer;
import org.apache.hyracks.storage.am.lsm.invertedindex.tokenizers.IToken;
import org.apache.hyracks.storage.am.lsm.invertedindex.tokenizers.ITokenFactory;
import org.apache.hyracks.storage.am.lsm.invertedindex.tokenizers.IntArray;
import org.apache.hyracks.util.string.UTF8StringUtil;

public abstract class AbstractUTF8StringBinaryTokenizer
implements IBinaryTokenizer {
    protected byte[] sentenceBytes;
    protected int sentenceStartOffset;
    protected int sentenceEndOffset;
    protected int sentenceUtf8Length;
    protected int byteIndex;
    protected final IntArray tokensStart;
    protected final IntArray tokensLength;
    protected final IToken token;
    protected final boolean ignoreTokenCount;
    protected final boolean sourceHasTypeTag;

    public AbstractUTF8StringBinaryTokenizer(boolean ignoreTokenCount, boolean sourceHasTypeTag, ITokenFactory tokenFactory) {
        this.ignoreTokenCount = ignoreTokenCount;
        this.sourceHasTypeTag = sourceHasTypeTag;
        if (!ignoreTokenCount) {
            this.tokensStart = new IntArray();
            this.tokensLength = new IntArray();
        } else {
            this.tokensStart = null;
            this.tokensLength = null;
        }
        this.token = tokenFactory.createToken();
    }

    @Override
    public IToken getToken() {
        return this.token;
    }

    @Override
    public void reset(byte[] sentenceData, int start, int length) {
        this.sentenceBytes = sentenceData;
        this.sentenceStartOffset = start;
        this.sentenceEndOffset = length + start;
        this.byteIndex = this.sentenceStartOffset;
        if (this.sourceHasTypeTag) {
            ++this.byteIndex;
        }
        this.sentenceUtf8Length = UTF8StringUtil.getUTFLength((byte[])sentenceData, (int)this.byteIndex);
        this.byteIndex += UTF8StringUtil.getNumBytesToStoreLength((int)this.sentenceUtf8Length);
        if (!this.ignoreTokenCount) {
            this.tokensStart.reset();
            this.tokensLength.reset();
        }
    }
}

