/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions.utils;

import java.io.DataOutput;
import java.io.IOException;
import java.security.SecureRandom;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.AMutableDouble;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.data.std.util.DataUtils;
import org.apache.hyracks.data.std.util.GrowableArray;

public final class RandomHelper {
    private final SecureRandom random = new SecureRandom();
    private final GrowableArray seed;
    private final AMutableDouble aDouble = new AMutableDouble(0.0);
    private ISerializerDeserializer doubleSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ADOUBLE);
    private final ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
    private final DataOutput dataOutput = this.resultStorage.getDataOutput();

    public RandomHelper(boolean withSeed) {
        this.seed = withSeed ? new GrowableArray(8) : null;
    }

    public void setSeed(byte[] bytes, int offset, int length) throws HyracksDataException {
        boolean sameSeed;
        if (this.seed == null) {
            throw new IllegalStateException();
        }
        boolean bl = sameSeed = this.seed.getLength() == length && DataUtils.equalsInRange((byte[])this.seed.getByteArray(), (int)0, (byte[])bytes, (int)offset, (int)length);
        if (!sameSeed) {
            try {
                this.seed.reset();
                this.seed.append(bytes, offset, length);
                this.random.setSeed(this.seed.getByteArray());
            }
            catch (IOException e) {
                throw HyracksDataException.create((Throwable)e);
            }
        }
    }

    public void nextDouble(IPointable resultPointable) throws HyracksDataException {
        this.aDouble.setValue(this.random.nextDouble());
        this.resultStorage.reset();
        this.doubleSerde.serialize((Object)this.aDouble, this.dataOutput);
        resultPointable.set((IValueReference)this.resultStorage);
    }
}

