/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.common.comm.io;

import org.apache.hyracks.api.comm.IFrame;
import org.apache.hyracks.api.comm.IFrameReader;
import org.apache.hyracks.api.comm.VSizeFrame;
import org.apache.hyracks.api.context.IHyracksFrameMgrContext;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.IOpenableDataReader;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.comm.io.FrameDeserializer;

public class FrameDeserializingDataReader
implements IOpenableDataReader<Object[]> {
    private final IFrame frame;
    private boolean eos;
    private boolean first;
    private final IFrameReader frameReader;
    private final FrameDeserializer frameDeserializer;

    public FrameDeserializingDataReader(IHyracksTaskContext ctx, IFrameReader frameReader, RecordDescriptor recordDescriptor) throws HyracksDataException {
        this.frame = new VSizeFrame((IHyracksFrameMgrContext)ctx);
        this.frameReader = frameReader;
        this.frameDeserializer = new FrameDeserializer(recordDescriptor);
    }

    public void open() throws HyracksDataException {
        this.frameReader.open();
        this.frame.reset();
        this.eos = false;
        this.first = true;
    }

    public void close() throws HyracksDataException {
        this.frameReader.close();
        this.frameDeserializer.close();
    }

    public Object[] readData() throws HyracksDataException {
        while (!this.eos) {
            if (!this.first && !this.frameDeserializer.done()) {
                return this.frameDeserializer.deserializeRecord();
            }
            this.frame.reset();
            if (!this.frameReader.nextFrame(this.frame)) {
                this.eos = true;
            } else {
                this.frameDeserializer.reset(this.frame.getBuffer());
            }
            this.first = false;
        }
        return null;
    }
}

