/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.nc.io;

import java.io.File;
import org.apache.commons.io.FileUtils;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.io.IIOManager;
import org.apache.hyracks.api.io.IWorkspaceFileFactory;
import org.apache.hyracks.api.resources.IDeallocatable;
import org.apache.hyracks.api.resources.IDeallocatableRegistry;

public final class WorkspaceFileFactory
implements IWorkspaceFileFactory {
    private final IDeallocatableRegistry registry;
    private final IIOManager ioManager;

    public WorkspaceFileFactory(IDeallocatableRegistry registry, IIOManager ioManager) {
        this.registry = registry;
        this.ioManager = ioManager;
    }

    public FileReference createManagedWorkspaceFile(String prefix) throws HyracksDataException {
        final FileReference fRef = this.ioManager.createWorkspaceFile(prefix);
        this.registry.registerDeallocatable(new IDeallocatable(){

            public void deallocate() {
                FileUtils.deleteQuietly((File)fRef.getFile());
            }
        });
        return fRef;
    }

    public FileReference createUnmanagedWorkspaceFile(String prefix) throws HyracksDataException {
        return this.ioManager.createWorkspaceFile(prefix);
    }
}

