/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions;

import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import org.apache.asterix.common.annotations.MissingNullInOutFunction;
import org.apache.asterix.om.exceptions.ExceptionUtil;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.asterix.runtime.evaluators.common.ListAccessor;
import org.apache.asterix.runtime.evaluators.functions.AbstractScalarEval;
import org.apache.asterix.runtime.evaluators.functions.PointableHelper;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;
import org.apache.hyracks.util.string.UTF8StringUtil;

@MissingNullInOutFunction
public abstract class AbstractConcatStringEval
extends AbstractScalarEval {
    private final int separatorPosition;
    static final int NO_SEPARATOR_POSITION = -1;
    private final IEvaluatorContext ctx;
    final ArrayBackedValueStorage storage = new ArrayBackedValueStorage();
    final DataOutput storageDataOutput = this.storage.getDataOutput();
    private final IScalarEvaluator[] evals;
    private final IPointable[] pointables;
    protected ListAccessor listAccessor = new ListAccessor();
    private final byte[] tempLengthArray = new byte[5];
    protected boolean isMissingMet = false;
    protected boolean isReturnNull = false;
    protected int argIndex = -1;
    protected byte[] expectedType = null;
    protected ATypeTag unsupportedType = null;
    protected final byte[] STRING_TYPE = new byte[]{ATypeTag.SERIALIZED_STRING_TYPE_TAG};

    public AbstractConcatStringEval(IScalarEvaluatorFactory[] args, IEvaluatorContext ctx, SourceLocation sourceLocation, FunctionIdentifier functionIdentifier, int separatorPosition) throws HyracksDataException {
        super(sourceLocation, functionIdentifier);
        this.ctx = ctx;
        this.separatorPosition = separatorPosition;
        this.pointables = new IPointable[args.length];
        this.evals = new IScalarEvaluator[args.length];
        for (int i = 0; i < args.length; ++i) {
            this.evals[i] = args[i].createScalarEvaluator(ctx);
            this.pointables[i] = new VoidPointable();
        }
    }

    protected abstract boolean isAcceptedType(ATypeTag var1);

    protected abstract byte[] getExpectedType();

    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
        ATypeTag separatorTypeTag;
        this.resetValidationVariables();
        for (int i = 0; i < this.evals.length; ++i) {
            this.evals[i].evaluate(tuple, this.pointables[i]);
            this.isMissingMet = this.doMissingNullCheck(result, this.pointables[i]);
            if (!this.isMissingMet) continue;
            return;
        }
        if (this.isReturnNull) {
            PointableHelper.setNull(result);
            return;
        }
        byte[] separatorBytes = null;
        int separatorStartOffset = 0;
        if (this.separatorPosition != -1 && (separatorTypeTag = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize((separatorBytes = this.pointables[this.separatorPosition].getByteArray())[separatorStartOffset = this.pointables[this.separatorPosition].getStartOffset()])) != ATypeTag.STRING) {
            this.isReturnNull = true;
            this.argIndex = this.separatorPosition;
            this.expectedType = this.STRING_TYPE;
            this.unsupportedType = separatorTypeTag;
        }
        for (int i = 0; i < this.pointables.length; ++i) {
            int startOffset;
            if (i == this.separatorPosition) continue;
            byte[] bytes = this.pointables[i].getByteArray();
            ATypeTag typeTag = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(bytes[startOffset = this.pointables[i].getStartOffset()]);
            if (!this.isAcceptedType(typeTag)) {
                this.isReturnNull = true;
                if (this.unsupportedType == null) {
                    this.argIndex = i;
                    this.expectedType = this.getExpectedType();
                    this.unsupportedType = typeTag;
                }
            }
            if (!typeTag.isListType()) continue;
            this.listAccessor.reset(bytes, startOffset);
            for (int j = 0; j < this.listAccessor.size(); ++j) {
                int itemStartOffset = this.listAccessor.getItemOffset(j);
                ATypeTag itemTypeTag = this.listAccessor.getItemType(itemStartOffset);
                if (itemTypeTag == ATypeTag.STRING) continue;
                if (itemTypeTag == ATypeTag.MISSING) {
                    PointableHelper.setMissing(result);
                    return;
                }
                this.isReturnNull = true;
                if (this.unsupportedType != null && itemTypeTag != ATypeTag.NULL) continue;
                this.argIndex = this.getActualArgumentIndex(i, j);
                this.expectedType = this.getExpectedType();
                this.unsupportedType = itemTypeTag;
            }
        }
        if (this.isReturnNull) {
            PointableHelper.setNull(result);
            if (this.unsupportedType != null && this.unsupportedType != ATypeTag.NULL) {
                ExceptionUtil.warnTypeMismatch((IEvaluatorContext)this.ctx, (SourceLocation)this.srcLoc, (FunctionIdentifier)this.funID, (byte)this.unsupportedType.serialize(), (int)this.argIndex, (byte[])this.expectedType);
            }
            return;
        }
        int utf8Length = this.calculateStringLength(separatorBytes, separatorStartOffset);
        this.constructConcatenatedString(utf8Length, separatorBytes, separatorStartOffset);
        result.set((IValueReference)this.storage);
    }

    private void resetValidationVariables() {
        this.isMissingMet = false;
        this.isReturnNull = false;
        this.argIndex = -1;
        this.expectedType = null;
        this.unsupportedType = null;
    }

    protected boolean doMissingNullCheck(IPointable result, IPointable pointable) throws HyracksDataException {
        if (PointableHelper.checkAndSetMissingOrNull(result, pointable)) {
            if (result.getByteArray()[result.getStartOffset()] == ATypeTag.SERIALIZED_MISSING_TYPE_TAG) {
                return true;
            }
            this.isReturnNull = true;
        }
        return false;
    }

    int getActualArgumentIndex(int outArgumentIndex, int innerArgumentIndex) {
        return outArgumentIndex;
    }

    private int calculateStringLength(byte[] separatorBytes, int separatorStartOffset) throws HyracksDataException {
        int utf8Length = 0;
        int separatorLength = 0;
        if (this.separatorPosition != -1) {
            separatorLength = UTF8StringUtil.getUTFLength((byte[])separatorBytes, (int)(separatorStartOffset + 1));
        }
        for (int i = 0; i < this.pointables.length; ++i) {
            if (i == this.separatorPosition) continue;
            byte[] bytes = this.pointables[i].getByteArray();
            int startOffset = this.pointables[i].getStartOffset();
            ATypeTag typeTag = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(bytes[startOffset]);
            try {
                if (typeTag == ATypeTag.STRING) {
                    utf8Length += UTF8StringUtil.getUTFLength((byte[])bytes, (int)(++startOffset));
                } else {
                    this.listAccessor.reset(bytes, startOffset);
                    for (int j = 0; j < this.listAccessor.size(); ++j) {
                        int itemStartOffset = this.listAccessor.getItemOffset(j);
                        if (this.listAccessor.itemsAreSelfDescribing()) {
                            ++itemStartOffset;
                        }
                        utf8Length += UTF8StringUtil.getUTFLength((byte[])bytes, (int)itemStartOffset);
                        if (this.separatorPosition == -1 || j >= this.listAccessor.size() - 1) continue;
                        utf8Length += separatorLength;
                    }
                }
            }
            catch (IOException ex) {
                throw HyracksDataException.create((Throwable)ex);
            }
            if (this.separatorPosition == -1 || i >= this.pointables.length - (this.separatorPosition > 0 ? 2 : 1)) continue;
            utf8Length += separatorLength;
        }
        return utf8Length;
    }

    private void constructConcatenatedString(int utf8Length, byte[] separatorBytes, int separatorStartOffset) throws HyracksDataException {
        try {
            Arrays.fill(this.tempLengthArray, (byte)0);
            int cbytes = UTF8StringUtil.encodeUTF8Length((int)utf8Length, (byte[])this.tempLengthArray, (int)0);
            this.storage.reset();
            this.storageDataOutput.writeByte(ATypeTag.SERIALIZED_STRING_TYPE_TAG);
            this.storageDataOutput.write(this.tempLengthArray, 0, cbytes);
            int separatorLength = 0;
            int separatorMetaLength = 0;
            if (this.separatorPosition != -1) {
                separatorLength = UTF8StringUtil.getUTFLength((byte[])separatorBytes, (int)(separatorStartOffset + 1));
                separatorMetaLength = UTF8StringUtil.getNumBytesToStoreLength((int)separatorLength);
            }
            for (int i = 0; i < this.pointables.length; ++i) {
                int StringLength;
                int startOffset;
                if (i == this.separatorPosition) continue;
                byte[] bytes = this.pointables[i].getByteArray();
                ATypeTag typeTag = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(bytes[startOffset = this.pointables[i].getStartOffset()]);
                if (typeTag == ATypeTag.STRING) {
                    StringLength = UTF8StringUtil.getUTFLength((byte[])bytes, (int)(++startOffset));
                    this.storageDataOutput.write(bytes, UTF8StringUtil.getNumBytesToStoreLength((int)StringLength) + startOffset, StringLength);
                } else {
                    this.listAccessor.reset(bytes, startOffset);
                    for (int j = 0; j < this.listAccessor.size(); ++j) {
                        int itemStartOffset = this.listAccessor.getItemOffset(j);
                        if (this.listAccessor.itemsAreSelfDescribing()) {
                            ++itemStartOffset;
                        }
                        StringLength = UTF8StringUtil.getUTFLength((byte[])bytes, (int)itemStartOffset);
                        this.storageDataOutput.write(bytes, UTF8StringUtil.getNumBytesToStoreLength((int)StringLength) + itemStartOffset, StringLength);
                        if (this.separatorPosition == -1 || j >= this.listAccessor.size() - 1) continue;
                        this.storageDataOutput.write(separatorBytes, separatorMetaLength + separatorStartOffset + 1, separatorLength);
                    }
                }
                if (this.separatorPosition == -1 || i >= this.pointables.length - (this.separatorPosition > 0 ? 2 : 1)) continue;
                this.storageDataOutput.write(separatorBytes, separatorMetaLength + separatorStartOffset + 1, separatorLength);
            }
        }
        catch (IOException ex) {
            throw HyracksDataException.create((Throwable)ex);
        }
    }
}

