/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.core.algebra.operators.logical;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.properties.TypePropagationPolicy;
import org.apache.hyracks.algebricks.core.algebra.typing.ITypeEnvPointer;
import org.apache.hyracks.algebricks.core.algebra.typing.ITypingContext;
import org.apache.hyracks.algebricks.core.algebra.typing.OpRefTypeEnvPointer;
import org.apache.hyracks.algebricks.core.algebra.typing.PropagatingTypeEnvironment;

public abstract class AbstractOperatorWithNestedPlans
extends AbstractLogicalOperator {
    protected final List<ILogicalPlan> nestedPlans;

    public AbstractOperatorWithNestedPlans() {
        this.nestedPlans = new ArrayList<ILogicalPlan>();
    }

    public AbstractOperatorWithNestedPlans(List<ILogicalPlan> nestedPlans) {
        this.nestedPlans = nestedPlans;
    }

    public List<ILogicalPlan> getNestedPlans() {
        return this.nestedPlans;
    }

    @Override
    public boolean hasNestedPlans() {
        return true;
    }

    public LinkedList<Mutable<ILogicalOperator>> allRootsInReverseOrder() {
        LinkedList<Mutable<ILogicalOperator>> allRoots = new LinkedList<Mutable<ILogicalOperator>>();
        for (ILogicalPlan p : this.nestedPlans) {
            for (Mutable<ILogicalOperator> r : p.getRoots()) {
                allRoots.addFirst(r);
            }
        }
        return allRoots;
    }

    @Override
    public void recomputeSchema() {
        this.schema = new ArrayList();
        this.schema.addAll(((ILogicalOperator)((Mutable)this.inputs.get(0)).getValue()).getSchema());
        for (ILogicalPlan p : this.nestedPlans) {
            for (Mutable<ILogicalOperator> r : p.getRoots()) {
                this.schema.addAll(((ILogicalOperator)r.getValue()).getSchema());
            }
        }
    }

    @Override
    public boolean isMap() {
        return false;
    }

    protected PropagatingTypeEnvironment createNestedPlansPropagatingTypeEnvironment(ITypingContext ctx, boolean propagateInput) {
        ITypeEnvPointer[] envPointers;
        int i;
        int n = 0;
        for (ILogicalPlan p : this.nestedPlans) {
            n += p.getRoots().size();
        }
        if (propagateInput) {
            i = this.inputs.size();
            envPointers = new ITypeEnvPointer[n + i];
            for (int j = 0; j < i; ++j) {
                envPointers[j] = new OpRefTypeEnvPointer((Mutable<ILogicalOperator>)((Mutable)this.inputs.get(j)), ctx);
            }
        } else {
            envPointers = new ITypeEnvPointer[n];
            i = 0;
        }
        for (ILogicalPlan p : this.nestedPlans) {
            for (Mutable<ILogicalOperator> r : p.getRoots()) {
                envPointers[i] = new OpRefTypeEnvPointer(r, ctx);
                ++i;
            }
        }
        return new PropagatingTypeEnvironment(ctx.getExpressionTypeComputer(), ctx.getMissableTypeComputer(), ctx.getMetadataProvider(), TypePropagationPolicy.ALL, envPointers);
    }

    public abstract void getUsedVariablesExceptNestedPlans(Collection<LogicalVariable> var1);

    public abstract void getProducedVariablesExceptNestedPlans(Collection<LogicalVariable> var1);
}

