/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.base.temporal;

import org.apache.asterix.om.base.temporal.GregorianCalendarSystem;

public class DurationArithmeticOperations {
    private static final GregorianCalendarSystem GREG_CAL = GregorianCalendarSystem.getInstance();

    private DurationArithmeticOperations() {
    }

    public static long addDuration(long pointChronon, int yearMonthDuration, long dayTimeDuration, boolean isTimeOnly) {
        if (isTimeOnly) {
            long rtnChronon = pointChronon + dayTimeDuration;
            if ((rtnChronon < 0L || rtnChronon > 86400000L) && (rtnChronon %= 86400000L) < 0L) {
                rtnChronon += 86400000L;
            }
            return rtnChronon;
        }
        int year = GREG_CAL.getYear(pointChronon);
        int month = GREG_CAL.getMonthOfYear(pointChronon, year);
        int day = GREG_CAL.getDayOfMonthYear(pointChronon, year, month);
        int hour = GREG_CAL.getHourOfDay(pointChronon);
        int min = GREG_CAL.getMinOfHour(pointChronon);
        int sec = GREG_CAL.getSecOfMin(pointChronon);
        int ms = GREG_CAL.getMillisOfSec(pointChronon);
        int carry = yearMonthDuration / 12;
        if ((month += yearMonthDuration % 12) < 1) {
            month += 12;
            --carry;
        } else if (month > 12) {
            month -= 12;
            ++carry;
        }
        boolean isLeapYear = GREG_CAL.isLeapYear(year += carry);
        if (isLeapYear) {
            if (day > GregorianCalendarSystem.DAYS_OF_MONTH_LEAP[month - 1]) {
                day = GregorianCalendarSystem.DAYS_OF_MONTH_LEAP[month - 1];
            }
        } else if (day > GregorianCalendarSystem.DAYS_OF_MONTH_ORDI[month - 1]) {
            day = GregorianCalendarSystem.DAYS_OF_MONTH_ORDI[month - 1];
        }
        return GREG_CAL.getChronon(year, month, day, hour, min, sec, ms, 0) + dayTimeDuration;
    }
}

