/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.client.util;

import org.apache.http.client.methods.RequestBuilder;
import org.keycloak.authorization.client.Configuration;
import org.keycloak.authorization.client.util.HttpMethod;
import org.keycloak.protocol.oidc.client.authentication.ClientCredentialsProvider;

public class Http {
    private final Configuration configuration;
    private final ClientCredentialsProvider authenticator;

    public Http(Configuration configuration, ClientCredentialsProvider authenticator) {
        this.configuration = configuration;
        this.authenticator = authenticator;
    }

    public <R> HttpMethod<R> get(String path) {
        return this.method(RequestBuilder.get().setUri(path));
    }

    public <R> HttpMethod<R> post(String path) {
        return this.method(RequestBuilder.post().setUri(path));
    }

    public <R> HttpMethod<R> put(String path) {
        return this.method(RequestBuilder.put().setUri(path));
    }

    public <R> HttpMethod<R> delete(String path) {
        return this.method(RequestBuilder.delete().setUri(path));
    }

    private <R> HttpMethod<R> method(RequestBuilder builder) {
        return new HttpMethod(this.configuration, this.authenticator, builder);
    }
}

