/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.vault.support;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import org.springframework.util.Assert;
import org.springframework.util.Base64Utils;
import org.springframework.vault.VaultException;
import org.springframework.vault.support.KeystoreUtil;
import org.springframework.vault.support.PemObject;

public class Certificate {
    private final String serialNumber;
    private final String certificate;
    private final String issuingCaCertificate;

    Certificate(@JsonProperty(value="serial_number") String serialNumber, @JsonProperty(value="certificate") String certificate, @JsonProperty(value="issuing_ca") String issuingCaCertificate) {
        this.serialNumber = serialNumber;
        this.certificate = certificate;
        this.issuingCaCertificate = issuingCaCertificate;
    }

    public static Certificate of(String serialNumber, String certificate, String issuingCaCertificate) {
        Assert.hasText((String)serialNumber, (String)"Serial number must not be empty");
        Assert.hasText((String)certificate, (String)"Certificate must not be empty");
        Assert.hasText((String)issuingCaCertificate, (String)"Issuing CA certificate must not be empty");
        return new Certificate(serialNumber, certificate, issuingCaCertificate);
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public String getCertificate() {
        return this.certificate;
    }

    public String getIssuingCaCertificate() {
        return this.issuingCaCertificate;
    }

    public X509Certificate getX509Certificate() {
        return this.doGetCertificate(this.getCertificate());
    }

    public X509Certificate getX509IssuerCertificate() {
        return this.doGetCertificate(this.getIssuingCaCertificate());
    }

    private X509Certificate doGetCertificate(String cert) {
        try {
            List<X509Certificate> certificates = Certificate.getCertificates(cert);
            if (certificates.isEmpty()) {
                throw new IllegalStateException("No certificate found");
            }
            return certificates.get(0);
        }
        catch (CertificateException e) {
            throw new VaultException("Cannot create Certificate from certificate", e);
        }
    }

    public KeyStore createTrustStore() {
        try {
            return KeystoreUtil.createKeyStore(this.getX509Certificate(), this.getX509IssuerCertificate());
        }
        catch (IOException | GeneralSecurityException e) {
            throw new VaultException("Cannot create KeyStore", e);
        }
    }

    static List<X509Certificate> getCertificates(String certificates) throws CertificateException {
        Assert.hasText((String)certificates, (String)"Certificates must not be empty");
        ArrayList<X509Certificate> result = new ArrayList<X509Certificate>(1);
        if (PemObject.isPemEncoded(certificates)) {
            List<PemObject> pemObjects = PemObject.parse(certificates);
            for (PemObject pemObject : pemObjects) {
                if (!pemObject.isCertificate()) continue;
                result.add(pemObject.getCertificate());
            }
        } else {
            result.addAll(KeystoreUtil.getCertificates(Base64Utils.decodeFromString((String)certificates)));
        }
        return result;
    }
}

