/*
 * Decompiled with CFR 0.152.
 */
package javax.jmdns.impl.tasks;

import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import javax.jmdns.impl.DNSIncoming;
import javax.jmdns.impl.DNSOutgoing;
import javax.jmdns.impl.DNSQuestion;
import javax.jmdns.impl.DNSRecord;
import javax.jmdns.impl.JmDNSImpl;

public abstract class DNSTask
extends TimerTask {
    private final JmDNSImpl jmDNS;

    protected DNSTask(JmDNSImpl jmDNSImpl) {
        this.jmDNS = jmDNSImpl;
    }

    public JmDNSImpl getDns() {
        return this.jmDNS;
    }

    public abstract void start(Timer var1);

    public abstract String getName();

    public String toString() {
        return this.getName();
    }

    public DNSOutgoing addQuestion(DNSOutgoing out, DNSQuestion rec) throws IOException {
        DNSOutgoing newOut = out;
        try {
            newOut.addQuestion(rec);
        }
        catch (IOException e) {
            newOut = this.getDnsOutgoing(newOut);
            newOut.addQuestion(rec);
        }
        return newOut;
    }

    private DNSOutgoing getDnsOutgoing(DNSOutgoing newOut) throws IOException {
        int flags = newOut.getFlags();
        boolean multicast = newOut.isMulticast();
        int maxUDPPayload = newOut.getMaxUDPPayload();
        int id = newOut.getId();
        newOut.setFlags(flags | 0x200);
        newOut.setId(id);
        this.jmDNS.send(newOut);
        newOut = new DNSOutgoing(flags, multicast, maxUDPPayload);
        return newOut;
    }

    public DNSOutgoing addAnswer(DNSOutgoing out, DNSIncoming in, DNSRecord rec) throws IOException {
        DNSOutgoing newOut = out;
        try {
            newOut.addAnswer(in, rec);
        }
        catch (IOException e) {
            newOut = this.getDnsOutgoing(newOut);
            newOut.addAnswer(in, rec);
        }
        return newOut;
    }

    public DNSOutgoing addAnswer(DNSOutgoing out, DNSRecord rec, long now) throws IOException {
        DNSOutgoing newOut = out;
        try {
            newOut.addAnswer(rec, now);
        }
        catch (IOException e) {
            newOut = this.getDnsOutgoing(newOut);
            newOut.addAnswer(rec, now);
        }
        return newOut;
    }

    public DNSOutgoing addAuthoritativeAnswer(DNSOutgoing out, DNSRecord rec) throws IOException {
        DNSOutgoing newOut = out;
        try {
            newOut.addAuthorativeAnswer(rec);
        }
        catch (IOException e) {
            newOut = this.getDnsOutgoing(newOut);
            newOut.addAuthorativeAnswer(rec);
        }
        return newOut;
    }

    public DNSOutgoing addAdditionalAnswer(DNSOutgoing out, DNSIncoming in, DNSRecord rec) throws IOException {
        DNSOutgoing newOut = out;
        try {
            newOut.addAdditionalAnswer(in, rec);
        }
        catch (IOException e) {
            newOut = this.getDnsOutgoing(newOut);
            newOut.addAdditionalAnswer(in, rec);
        }
        return newOut;
    }
}

