/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.loadbalancer;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Exchange;
import org.apache.camel.processor.loadbalancer.QueueLoadBalancer;

public class RoundRobinLoadBalancer
extends QueueLoadBalancer {
    private final AtomicInteger counter = new AtomicInteger(-1);

    @Override
    protected AsyncProcessor chooseProcessor(AsyncProcessor[] processors, Exchange exchange) {
        int size = processors.length;
        int c = this.counter.updateAndGet(x -> ++x < size ? x : 0);
        return processors[c];
    }

    public int getLastChosenProcessorIndex() {
        return this.counter.get();
    }
}

