/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElementRef;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import java.util.ArrayList;
import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.model.OptionalIdentifiedDefinition;
import org.apache.camel.model.TemplatedRouteContainer;
import org.apache.camel.model.TemplatedRouteDefinition;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.Resource;
import org.apache.camel.spi.ResourceAware;

@Metadata(label="configuration")
@XmlRootElement(name="templatedRoutes")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class TemplatedRoutesDefinition
extends OptionalIdentifiedDefinition<TemplatedRoutesDefinition>
implements TemplatedRouteContainer,
CamelContextAware,
ResourceAware {
    @XmlTransient
    private CamelContext camelContext;
    @XmlTransient
    private Resource resource;
    @XmlElementRef
    private List<TemplatedRouteDefinition> templatedRoutes = new ArrayList<TemplatedRouteDefinition>();

    public Resource getResource() {
        return this.resource;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public String toString() {
        return "TemplatedRoutes: " + String.valueOf(this.templatedRoutes);
    }

    public String getShortName() {
        return "templatedRoutes";
    }

    public String getLabel() {
        return "TemplatedRoutes " + this.getId();
    }

    @Override
    public List<TemplatedRouteDefinition> getTemplatedRoutes() {
        return this.templatedRoutes;
    }

    @Override
    public void setTemplatedRoutes(List<TemplatedRouteDefinition> templatedRoutes) {
        this.templatedRoutes = templatedRoutes;
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public TemplatedRouteDefinition templatedRoute(String routeTemplateId) {
        TemplatedRouteDefinition template = this.createTemplatedRouteDefinition(routeTemplateId);
        this.getTemplatedRoutes().add(template);
        return template;
    }

    public TemplatedRouteDefinition templatedRoute(TemplatedRouteDefinition template) {
        this.getTemplatedRoutes().add(template);
        return template;
    }

    protected TemplatedRouteDefinition createTemplatedRouteDefinition(String id) {
        TemplatedRouteDefinition templatedRoute = new TemplatedRouteDefinition();
        if (id != null) {
            templatedRoute.setRouteTemplateRef(id);
        }
        if (this.resource != null) {
            templatedRoute.setResource(this.resource);
        }
        CamelContextAware.trySetCamelContext((Object)templatedRoute, (CamelContext)this.camelContext);
        return templatedRoute;
    }
}

